/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.modbus.model;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.modbus.enums.EMbFunctionCode;
import com.github.xingshuangs.iot.protocol.modbus.model.MbPdu;
import java.util.Arrays;

public final class MbReadDiscreteInputResponse
extends MbPdu {
    private int count;
    private byte[] inputStatus;

    public MbReadDiscreteInputResponse() {
        this.functionCode = EMbFunctionCode.READ_DISCRETE_INPUT;
    }

    @Override
    public int byteArrayLength() {
        return super.byteArrayLength() + 1 + this.inputStatus.length;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(this.byteArrayLength()).putByte(this.functionCode.getCode()).putByte(this.count).putBytes(this.inputStatus).getData();
    }

    public static MbReadDiscreteInputResponse fromBytes(byte[] data) {
        return MbReadDiscreteInputResponse.fromBytes(data, 0);
    }

    public static MbReadDiscreteInputResponse fromBytes(byte[] data, int offset) {
        ByteReadBuff buff = new ByteReadBuff(data, offset);
        MbReadDiscreteInputResponse res = new MbReadDiscreteInputResponse();
        res.functionCode = EMbFunctionCode.from(buff.getByte());
        res.count = buff.getByteToInt();
        res.inputStatus = buff.getBytes(res.count);
        return res;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MbReadDiscreteInputResponse)) {
            return false;
        }
        MbReadDiscreteInputResponse other = (MbReadDiscreteInputResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        return Arrays.equals(this.getInputStatus(), other.getInputStatus());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MbReadDiscreteInputResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getCount();
        result = result * 59 + Arrays.hashCode(this.getInputStatus());
        return result;
    }

    public int getCount() {
        return this.count;
    }

    public byte[] getInputStatus() {
        return this.inputStatus;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setInputStatus(byte[] inputStatus) {
        this.inputStatus = inputStatus;
    }

    @Override
    public String toString() {
        return "MbReadDiscreteInputResponse(count=" + this.getCount() + ", inputStatus=" + Arrays.toString(this.getInputStatus()) + ")";
    }
}

