/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.modbus.model;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.modbus.enums.EMbFunctionCode;
import com.github.xingshuangs.iot.protocol.modbus.model.MbPdu;
import java.util.Arrays;

public final class MbReadInputRegisterResponse
extends MbPdu {
    private int count;
    private byte[] register;

    public MbReadInputRegisterResponse() {
        this.functionCode = EMbFunctionCode.READ_INPUT_REGISTER;
    }

    @Override
    public int byteArrayLength() {
        return super.byteArrayLength() + 1 + this.register.length;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(this.byteArrayLength()).putByte(this.functionCode.getCode()).putByte(this.count).putBytes(this.register).getData();
    }

    public static MbReadInputRegisterResponse fromBytes(byte[] data) {
        return MbReadInputRegisterResponse.fromBytes(data, 0);
    }

    public static MbReadInputRegisterResponse fromBytes(byte[] data, int offset) {
        ByteReadBuff buff = new ByteReadBuff(data, offset);
        MbReadInputRegisterResponse res = new MbReadInputRegisterResponse();
        res.functionCode = EMbFunctionCode.from(buff.getByte());
        res.count = buff.getByteToInt();
        res.register = buff.getBytes(res.count);
        return res;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MbReadInputRegisterResponse)) {
            return false;
        }
        MbReadInputRegisterResponse other = (MbReadInputRegisterResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        return Arrays.equals(this.getRegister(), other.getRegister());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MbReadInputRegisterResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getCount();
        result = result * 59 + Arrays.hashCode(this.getRegister());
        return result;
    }

    public int getCount() {
        return this.count;
    }

    public byte[] getRegister() {
        return this.register;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setRegister(byte[] register) {
        this.register = register;
    }

    @Override
    public String toString() {
        return "MbReadInputRegisterResponse(count=" + this.getCount() + ", register=" + Arrays.toString(this.getRegister()) + ")";
    }
}

