/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.modbus.model;

import com.github.xingshuangs.iot.common.IObjectByteArray;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.exceptions.ModbusCommException;
import com.github.xingshuangs.iot.protocol.modbus.model.MbPdu;
import com.github.xingshuangs.iot.protocol.modbus.model.MbapHeader;

public class MbTcpRequest
implements IObjectByteArray {
    private MbapHeader header;
    private MbPdu pdu;

    public MbTcpRequest() {
    }

    public MbTcpRequest(MbapHeader header, MbPdu pdu) {
        this.header = header;
        this.pdu = pdu;
    }

    @Override
    public int byteArrayLength() {
        return this.header.byteArrayLength() + this.pdu.byteArrayLength();
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(this.byteArrayLength()).putBytes(this.header.toByteArray()).putBytes(this.pdu.toByteArray()).getData();
    }

    public void selfCheck() {
        if (this.header == null) {
            throw new ModbusCommException("header is null");
        }
        if (this.pdu == null) {
            throw new ModbusCommException("pdu is null");
        }
        this.header.setLength(this.pdu.byteArrayLength() + 1);
    }

    public static MbTcpRequest createDefault() {
        MbTcpRequest request = new MbTcpRequest();
        request.header = new MbapHeader(MbapHeader.getNewNumber());
        return request;
    }

    public static MbTcpRequest fromBytes(byte[] data) {
        MbTcpRequest request = new MbTcpRequest();
        request.header = MbapHeader.fromBytes(data);
        request.pdu = MbPdu.fromBytesToRequest(data, request.header.byteArrayLength());
        return request;
    }

    public static MbTcpRequest fromBytes(MbapHeader header, byte[] pduBytes) {
        MbTcpRequest request = new MbTcpRequest();
        request.header = header;
        request.pdu = MbPdu.fromBytesToRequest(pduBytes);
        return request;
    }

    public MbapHeader getHeader() {
        return this.header;
    }

    public MbPdu getPdu() {
        return this.pdu;
    }

    public void setHeader(MbapHeader header) {
        this.header = header;
    }

    public void setPdu(MbPdu pdu) {
        this.pdu = pdu;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MbTcpRequest)) {
            return false;
        }
        MbTcpRequest other = (MbTcpRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MbapHeader this$header = this.getHeader();
        MbapHeader other$header = other.getHeader();
        if (this$header == null ? other$header != null : !((Object)this$header).equals(other$header)) {
            return false;
        }
        MbPdu this$pdu = this.getPdu();
        MbPdu other$pdu = other.getPdu();
        return !(this$pdu == null ? other$pdu != null : !((Object)this$pdu).equals(other$pdu));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MbTcpRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MbapHeader $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : ((Object)$header).hashCode());
        MbPdu $pdu = this.getPdu();
        result = result * 59 + ($pdu == null ? 43 : ((Object)$pdu).hashCode());
        return result;
    }

    public String toString() {
        return "MbTcpRequest(header=" + this.getHeader() + ", pdu=" + this.getPdu() + ")";
    }
}

