/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.modbus.model;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.modbus.enums.EMbFunctionCode;
import com.github.xingshuangs.iot.protocol.modbus.model.MbPdu;

public final class MbWriteMultipleRegisterResponse
extends MbPdu {
    private int address;
    private int quantity;

    public MbWriteMultipleRegisterResponse() {
        this.functionCode = EMbFunctionCode.WRITE_MULTIPLE_REGISTER;
    }

    @Override
    public int byteArrayLength() {
        return super.byteArrayLength() + 4;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(this.byteArrayLength()).putByte(this.functionCode.getCode()).putShort(this.address).putShort(this.quantity).getData();
    }

    public static MbWriteMultipleRegisterResponse fromBytes(byte[] data) {
        return MbWriteMultipleRegisterResponse.fromBytes(data, 0);
    }

    public static MbWriteMultipleRegisterResponse fromBytes(byte[] data, int offset) {
        ByteReadBuff buff = new ByteReadBuff(data, offset);
        MbWriteMultipleRegisterResponse res = new MbWriteMultipleRegisterResponse();
        res.functionCode = EMbFunctionCode.from(buff.getByte());
        res.address = buff.getUInt16();
        res.quantity = buff.getUInt16();
        return res;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MbWriteMultipleRegisterResponse)) {
            return false;
        }
        MbWriteMultipleRegisterResponse other = (MbWriteMultipleRegisterResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getAddress() != other.getAddress()) {
            return false;
        }
        return this.getQuantity() == other.getQuantity();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MbWriteMultipleRegisterResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getAddress();
        result = result * 59 + this.getQuantity();
        return result;
    }

    public int getAddress() {
        return this.address;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setAddress(int address) {
        this.address = address;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    @Override
    public String toString() {
        return "MbWriteMultipleRegisterResponse(address=" + this.getAddress() + ", quantity=" + this.getQuantity() + ")";
    }
}

