/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.modbus.model;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.modbus.enums.EMbFunctionCode;
import com.github.xingshuangs.iot.protocol.modbus.model.MbPdu;

public final class MbWriteSingleCoilRequest
extends MbPdu {
    public static final byte[] ON = new byte[]{-1, 0};
    public static final byte[] OFF = new byte[]{0, 0};
    private int address;
    private boolean value;

    public MbWriteSingleCoilRequest() {
        this.functionCode = EMbFunctionCode.WRITE_SINGLE_COIL;
    }

    public MbWriteSingleCoilRequest(int address, boolean value) {
        this.functionCode = EMbFunctionCode.WRITE_SINGLE_COIL;
        this.address = address;
        this.value = value;
    }

    @Override
    public int byteArrayLength() {
        return super.byteArrayLength() + 4;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(this.byteArrayLength()).putByte(this.functionCode.getCode()).putShort(this.address).putBytes(this.value ? ON : OFF).getData();
    }

    public static MbWriteSingleCoilRequest fromBytes(byte[] data) {
        return MbWriteSingleCoilRequest.fromBytes(data, 0);
    }

    public static MbWriteSingleCoilRequest fromBytes(byte[] data, int offset) {
        ByteReadBuff buff = new ByteReadBuff(data, offset);
        MbWriteSingleCoilRequest res = new MbWriteSingleCoilRequest();
        res.functionCode = EMbFunctionCode.from(buff.getByte());
        res.address = buff.getUInt16();
        res.value = buff.getByte() == ON[0];
        return res;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MbWriteSingleCoilRequest)) {
            return false;
        }
        MbWriteSingleCoilRequest other = (MbWriteSingleCoilRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getAddress() != other.getAddress()) {
            return false;
        }
        return this.isValue() == other.isValue();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MbWriteSingleCoilRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getAddress();
        result = result * 59 + (this.isValue() ? 79 : 97);
        return result;
    }

    public int getAddress() {
        return this.address;
    }

    public boolean isValue() {
        return this.value;
    }

    public void setAddress(int address) {
        this.address = address;
    }

    public void setValue(boolean value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return "MbWriteSingleCoilRequest(address=" + this.getAddress() + ", value=" + this.isValue() + ")";
    }
}

