/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.modbus.model;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.modbus.enums.EMbFunctionCode;
import com.github.xingshuangs.iot.protocol.modbus.model.MbPdu;
import java.util.Arrays;

public final class MbWriteSingleRegisterResponse
extends MbPdu {
    private int address;
    private byte[] value;

    public MbWriteSingleRegisterResponse() {
        this.functionCode = EMbFunctionCode.WRITE_SINGLE_REGISTER;
    }

    @Override
    public int byteArrayLength() {
        return super.byteArrayLength() + 4;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(this.byteArrayLength()).putByte(this.functionCode.getCode()).putShort(this.address).putBytes(this.value).getData();
    }

    public static MbWriteSingleRegisterResponse fromBytes(byte[] data) {
        return MbWriteSingleRegisterResponse.fromBytes(data, 0);
    }

    public static MbWriteSingleRegisterResponse fromBytes(byte[] data, int offset) {
        ByteReadBuff buff = new ByteReadBuff(data, offset);
        MbWriteSingleRegisterResponse res = new MbWriteSingleRegisterResponse();
        res.functionCode = EMbFunctionCode.from(buff.getByte());
        res.address = buff.getUInt16();
        res.value = buff.getBytes(2);
        return res;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MbWriteSingleRegisterResponse)) {
            return false;
        }
        MbWriteSingleRegisterResponse other = (MbWriteSingleRegisterResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getAddress() != other.getAddress()) {
            return false;
        }
        return Arrays.equals(this.getValue(), other.getValue());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MbWriteSingleRegisterResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getAddress();
        result = result * 59 + Arrays.hashCode(this.getValue());
        return result;
    }

    public int getAddress() {
        return this.address;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setAddress(int address) {
        this.address = address;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return "MbWriteSingleRegisterResponse(address=" + this.getAddress() + ", value=" + Arrays.toString(this.getValue()) + ")";
    }
}

