/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.modbus.service;

import com.github.xingshuangs.iot.exceptions.ModbusCommException;
import com.github.xingshuangs.iot.protocol.modbus.model.MbAsciiRequest;
import com.github.xingshuangs.iot.protocol.modbus.model.MbAsciiResponse;
import com.github.xingshuangs.iot.protocol.modbus.model.MbErrorResponse;
import com.github.xingshuangs.iot.protocol.modbus.model.MbPdu;
import com.github.xingshuangs.iot.protocol.modbus.service.ModbusSkeletonAbstract;
import com.github.xingshuangs.iot.utils.HexUtil;
import java.nio.charset.StandardCharsets;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusAsciiOverTcp
extends ModbusSkeletonAbstract<MbAsciiRequest, MbAsciiResponse> {
    private static final Logger log = LoggerFactory.getLogger(ModbusAsciiOverTcp.class);
    private BiConsumer<String, String> comStringCallback;

    public void setComStringCallback(BiConsumer<String, String> comStringCallback) {
        this.comStringCallback = comStringCallback;
    }

    public ModbusAsciiOverTcp() {
        this(1, "127.0.0.1", 502);
    }

    public ModbusAsciiOverTcp(String ip) {
        this(1, ip, 502);
    }

    public ModbusAsciiOverTcp(String ip, int port) {
        this(1, ip, port);
    }

    public ModbusAsciiOverTcp(int unitId) {
        this(unitId, "127.0.0.1", 502);
    }

    public ModbusAsciiOverTcp(int unitId, String ip) {
        this(unitId, ip, 502);
    }

    public ModbusAsciiOverTcp(int unitId, String ip, int port) {
        super(unitId, ip, port);
        this.tag = "ModbusAscii";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MbAsciiResponse readFromServer(MbAsciiRequest req) {
        int len;
        String reqStr = ":" + HexUtil.toHexString(req.toByteArray(), "") + "\r\n";
        byte[] reqBytes = reqStr.getBytes(StandardCharsets.US_ASCII);
        if (this.comCallback != null) {
            this.comCallback.accept("REQ", reqBytes);
        }
        if (this.comStringCallback != null) {
            this.comStringCallback.accept("REQ", reqStr);
        }
        byte[] data = new byte[1024];
        try {
            this.locker.lock();
            this.write(reqBytes);
            len = this.read(data);
        }
        finally {
            this.locker.unlock();
        }
        if (len <= 0) {
            throw new ModbusCommException("The length of Modbus data read is incorrect");
        }
        byte[] total = new byte[len];
        System.arraycopy(data, 0, total, 0, len);
        String ackStr = new String(total, StandardCharsets.UTF_8);
        if (this.comCallback != null) {
            this.comCallback.accept("ACK", total);
        }
        if (this.comStringCallback != null) {
            this.comStringCallback.accept("ACK", ackStr);
        }
        ackStr = ackStr.replace(":", "").replace("\r\n", "");
        byte[] ackBytes = HexUtil.toHexArray(ackStr);
        MbAsciiResponse ack = MbAsciiResponse.fromBytes(ackBytes);
        this.checkResult(req, ack);
        return ack;
    }

    @Override
    protected void checkResult(MbAsciiRequest req, MbAsciiResponse ack) {
        if (!ack.checkLrc()) {
            throw new ModbusCommException("Response data LRC verification failed");
        }
        if (ack.getPdu() == null) {
            throw new ModbusCommException("PDU is null");
        }
        if (ack.getPdu().getFunctionCode().getCode() == (req.getPdu().getFunctionCode().getCode() | 0xFFFFFF80)) {
            MbErrorResponse response = (MbErrorResponse)ack.getPdu();
            throw new ModbusCommException("The response returns an exception, the exception code:" + response.getErrorCode().getDescription());
        }
        if (ack.getPdu().getFunctionCode().getCode() != req.getPdu().getFunctionCode().getCode()) {
            MbErrorResponse response = (MbErrorResponse)ack.getPdu();
            throw new ModbusCommException("The return function code is inconsistent with the send function code. The exception code is:" + response.getErrorCode().getDescription());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MbPdu readModbusData(int unitId, MbPdu reqPdu) {
        MbAsciiRequest request = new MbAsciiRequest(unitId, reqPdu);
        try {
            MbAsciiResponse response = this.readFromServer(request);
            MbPdu mbPdu = response.getPdu();
            return mbPdu;
        }
        finally {
            if (!this.persistence) {
                log.debug("Due to the short connection mode, the communication is completed and the connection channel is triggered to close, Server IP[{}]", (Object)this.socketAddress);
                this.close();
            }
        }
    }
}

