/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.modbus.service;

import com.github.xingshuangs.iot.common.algorithm.LoopGroupAlg;
import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.common.buff.EByteBuffFormat;
import com.github.xingshuangs.iot.net.client.TcpClientBasic;
import com.github.xingshuangs.iot.protocol.modbus.model.MbPdu;
import com.github.xingshuangs.iot.protocol.modbus.model.MbReadCoilRequest;
import com.github.xingshuangs.iot.protocol.modbus.model.MbReadCoilResponse;
import com.github.xingshuangs.iot.protocol.modbus.model.MbReadDiscreteInputRequest;
import com.github.xingshuangs.iot.protocol.modbus.model.MbReadDiscreteInputResponse;
import com.github.xingshuangs.iot.protocol.modbus.model.MbReadHoldRegisterRequest;
import com.github.xingshuangs.iot.protocol.modbus.model.MbReadHoldRegisterResponse;
import com.github.xingshuangs.iot.protocol.modbus.model.MbReadInputRegisterRequest;
import com.github.xingshuangs.iot.protocol.modbus.model.MbReadInputRegisterResponse;
import com.github.xingshuangs.iot.protocol.modbus.model.MbWriteMultipleCoilRequest;
import com.github.xingshuangs.iot.protocol.modbus.model.MbWriteMultipleRegisterRequest;
import com.github.xingshuangs.iot.protocol.modbus.model.MbWriteSingleCoilRequest;
import com.github.xingshuangs.iot.protocol.modbus.model.MbWriteSingleRegisterRequest;
import com.github.xingshuangs.iot.utils.BooleanUtil;
import com.github.xingshuangs.iot.utils.ByteUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ModbusSkeletonAbstract<T, R>
extends TcpClientBasic {
    private static final Logger log = LoggerFactory.getLogger(ModbusSkeletonAbstract.class);
    protected int unitId = 1;
    protected final ReentrantLock locker = new ReentrantLock();
    protected BiConsumer<String, byte[]> comCallback;
    protected boolean persistence = true;
    private int maxLengthOfReadCoil = 2000;
    private int maxLengthOfWriteCoil = 1968;
    private int maxLengthOfReadDiscreteInput = 2000;
    private int maxLengthOfReadHoldRegister = 125;
    private int maxLengthOfWriteHoldRegister = 123;
    private int maxLengthOfReadInputRegister = 125;

    public ModbusSkeletonAbstract() {
    }

    public ModbusSkeletonAbstract(int unitId, String host, int port) {
        super(host, port);
        this.unitId = unitId;
    }

    @Override
    public void connect() {
        try {
            super.connect();
        }
        finally {
            if (!this.persistence) {
                this.close();
            }
        }
    }

    protected abstract R readFromServer(T var1);

    protected abstract void checkResult(T var1, R var2);

    protected abstract MbPdu readModbusData(int var1, MbPdu var2);

    public List<Boolean> readCoil(int address, int quantity) {
        return this.readCoil(this.unitId, address, quantity);
    }

    public List<Boolean> readCoil(int unitId, int address, int quantity) {
        if (address < 0 || address > 65535) {
            throw new IllegalArgumentException("address < 0 || address > 65535");
        }
        if (quantity < 1) {
            throw new IllegalArgumentException("quantity<1");
        }
        ArrayList<Boolean> res = new ArrayList<Boolean>();
        LoopGroupAlg.loopExecute(quantity, this.maxLengthOfReadCoil, (off, len) -> {
            MbReadCoilRequest reqPdu = new MbReadCoilRequest(address + off, (int)len);
            MbReadCoilResponse resPdu = (MbReadCoilResponse)this.readModbusData(unitId, reqPdu);
            List<Boolean> booleans = BooleanUtil.byteArrayToList(len, resPdu.getCoilStatus());
            res.addAll(booleans);
        });
        return res;
    }

    public void writeCoil(int address, boolean coilStatus) {
        this.writeCoil(this.unitId, address, coilStatus);
    }

    public void writeCoil(int unitId, int address, boolean coilStatus) {
        if (address < 0 || address > 65535) {
            throw new IllegalArgumentException("address < 0 || address > 65535");
        }
        MbWriteSingleCoilRequest reqPdu = new MbWriteSingleCoilRequest(address, coilStatus);
        this.readModbusData(unitId, reqPdu);
    }

    public void writeCoil(int address, List<Boolean> coilStatus) {
        this.writeCoil(this.unitId, address, coilStatus);
    }

    public void writeCoil(int unitId, int address, List<Boolean> coilStatus) {
        if (address < 0 || address > 65535) {
            throw new IllegalArgumentException("address < 0 || address > 65535");
        }
        if (coilStatus.isEmpty()) {
            throw new IllegalArgumentException("coilStatus list is empty");
        }
        LoopGroupAlg.loopExecute(coilStatus.size(), this.maxLengthOfWriteCoil, (off, len) -> {
            List<Boolean> booleanList = coilStatus.subList((int)off, off + len);
            byte[] values = BooleanUtil.listToByteArray(booleanList);
            MbWriteMultipleCoilRequest reqPdu = new MbWriteMultipleCoilRequest(address + off, (int)len, values);
            this.readModbusData(unitId, reqPdu);
        });
    }

    public List<Boolean> readDiscreteInput(int address, int quantity) {
        return this.readDiscreteInput(this.unitId, address, quantity);
    }

    public List<Boolean> readDiscreteInput(int unitId, int address, int quantity) {
        if (address < 0 || address > 65535) {
            throw new IllegalArgumentException("address < 0 || address > 65535");
        }
        if (quantity < 1) {
            throw new IllegalArgumentException("quantity<1");
        }
        ArrayList<Boolean> res = new ArrayList<Boolean>();
        LoopGroupAlg.loopExecute(quantity, this.maxLengthOfReadDiscreteInput, (off, len) -> {
            MbReadDiscreteInputRequest reqPdu = new MbReadDiscreteInputRequest(address + off, (int)len);
            MbReadDiscreteInputResponse resPdu = (MbReadDiscreteInputResponse)this.readModbusData(unitId, reqPdu);
            List<Boolean> booleans = BooleanUtil.byteArrayToList(len, resPdu.getInputStatus());
            res.addAll(booleans);
        });
        return res;
    }

    public byte[] readHoldRegister(int address, int quantity) {
        return this.readHoldRegister(this.unitId, address, quantity);
    }

    public byte[] readHoldRegister(int unitId, int address, int quantity) {
        if (address < 0 || address > 65535) {
            throw new IllegalArgumentException("address < 0 || address > 65535");
        }
        if (quantity < 1) {
            throw new IllegalArgumentException("quantity < 1");
        }
        ByteWriteBuff buff = ByteWriteBuff.newInstance(quantity * 2);
        LoopGroupAlg.loopExecute(quantity, this.maxLengthOfReadHoldRegister, (off, len) -> {
            MbReadHoldRegisterRequest reqPdu = new MbReadHoldRegisterRequest(address + off, (int)len);
            MbReadHoldRegisterResponse resPdu = (MbReadHoldRegisterResponse)this.readModbusData(unitId, reqPdu);
            buff.putBytes(resPdu.getRegister());
        });
        return buff.getData();
    }

    public void writeHoldRegister(int address, int value) {
        this.writeHoldRegister(this.unitId, address, value);
    }

    public void writeHoldRegister(int unitId, int address, int value) {
        if (address < 0 || address > 65535) {
            throw new IllegalArgumentException("address < 0 || address > 65535");
        }
        if (value < 0 || value > 65535) {
            throw new IllegalArgumentException("value < 0 || value > 65535");
        }
        MbWriteSingleRegisterRequest reqPdu = new MbWriteSingleRegisterRequest(address, value);
        this.readModbusData(unitId, reqPdu);
    }

    public void writeHoldRegister(int address, byte[] values) {
        this.writeHoldRegister(this.unitId, address, values);
    }

    public void writeHoldRegister(int unitId, int address, byte[] values) {
        if (address < 0 || address > 65535) {
            throw new IllegalArgumentException("address < 0 || address > 65535");
        }
        byte[] newValues = values;
        if (values.length % 2 != 0) {
            newValues = ByteWriteBuff.newInstance(values.length + 1).putBytes(values).getData();
        }
        ByteReadBuff buff = ByteReadBuff.newInstance(newValues);
        LoopGroupAlg.loopExecute(newValues.length / 2, this.maxLengthOfWriteHoldRegister, (off, len) -> {
            byte[] bytes = buff.getBytes(off * 2, len * 2);
            MbWriteMultipleRegisterRequest reqPdu = new MbWriteMultipleRegisterRequest(address + off, (int)len, bytes);
            this.readModbusData(unitId, reqPdu);
        });
    }

    public void writeHoldRegister(int address, List<Integer> values) {
        this.writeHoldRegister(this.unitId, address, values);
    }

    public void writeHoldRegister(int unitId, int address, List<Integer> values) {
        if (values.isEmpty()) {
            throw new IllegalArgumentException("values is empty");
        }
        ByteWriteBuff buff = ByteWriteBuff.newInstance(values.size() * 2);
        values.forEach(buff::putShort);
        this.writeHoldRegister(unitId, address, buff.getData());
    }

    public byte[] readInputRegister(int address, int quantity) {
        return this.readInputRegister(this.unitId, address, quantity);
    }

    public byte[] readInputRegister(int unitId, int address, int quantity) {
        if (address < 0 || address > 65535) {
            throw new IllegalArgumentException("address < 0 || address > 65535");
        }
        if (quantity < 1) {
            throw new IllegalArgumentException("quantity < 1");
        }
        ByteWriteBuff buff = ByteWriteBuff.newInstance(quantity * 2);
        LoopGroupAlg.loopExecute(quantity, this.maxLengthOfReadInputRegister, (off, len) -> {
            MbReadInputRegisterRequest reqPdu = new MbReadInputRegisterRequest(address + off, (int)len);
            MbReadInputRegisterResponse resPdu = (MbReadInputRegisterResponse)this.readModbusData(unitId, reqPdu);
            buff.putBytes(resPdu.getRegister());
        });
        return buff.getData();
    }

    public boolean readBoolean(int address, int bitIndex) {
        return this.readBoolean(this.unitId, address, bitIndex);
    }

    public boolean readBoolean(int unitId, int address, int bitIndex) {
        if (bitIndex < 0 || bitIndex > 15) {
            throw new IllegalArgumentException("bitIndex < 0 || bitIndex > 15");
        }
        byte[] res = this.readHoldRegister(unitId, address, 1);
        int byteOffset = bitIndex / 8;
        int bitOffset = bitIndex % 8;
        return ByteReadBuff.newInstance(res).getBoolean(byteOffset, bitOffset);
    }

    public short readInt16(int address) {
        return this.readInt16(this.unitId, address, false);
    }

    public short readInt16(int address, boolean littleEndian) {
        return this.readInt16(this.unitId, address, littleEndian);
    }

    public short readInt16(int unitId, int address) {
        return this.readInt16(unitId, address, false);
    }

    public short readInt16(int unitId, int address, boolean littleEndian) {
        byte[] res = this.readHoldRegister(unitId, address, 1);
        return ByteReadBuff.newInstance(res, littleEndian).getInt16();
    }

    public int readUInt16(int address) {
        return this.readUInt16(this.unitId, address, false);
    }

    public int readUInt16(int address, boolean littleEndian) {
        return this.readUInt16(this.unitId, address, littleEndian);
    }

    public int readUInt16(int unitId, int address) {
        return this.readUInt16(unitId, address, false);
    }

    public int readUInt16(int unitId, int address, boolean littleEndian) {
        byte[] res = this.readHoldRegister(unitId, address, 1);
        return ByteReadBuff.newInstance(res, littleEndian).getUInt16();
    }

    public int readInt32(int address) {
        return this.readInt32(this.unitId, address, EByteBuffFormat.BA_DC);
    }

    public int readInt32(int address, EByteBuffFormat format) {
        return this.readInt32(this.unitId, address, format);
    }

    public int readInt32(int unitId, int address) {
        return this.readInt32(unitId, address, EByteBuffFormat.BA_DC);
    }

    public int readInt32(int unitId, int address, EByteBuffFormat format) {
        return this.readInt32(unitId, address, false, format);
    }

    public int readInt32(int unitId, int address, boolean littleEndian, EByteBuffFormat format) {
        byte[] res = this.readHoldRegister(unitId, address, 2);
        return ByteReadBuff.newInstance(res, 0, littleEndian, format).getInt32();
    }

    public long readUInt32(int address) {
        return this.readUInt32(this.unitId, address, EByteBuffFormat.BA_DC);
    }

    public long readUInt32(int address, EByteBuffFormat format) {
        return this.readUInt32(this.unitId, address, format);
    }

    public long readUInt32(int unitId, int address) {
        return this.readUInt32(unitId, address, EByteBuffFormat.BA_DC);
    }

    public long readUInt32(int unitId, int address, EByteBuffFormat format) {
        return this.readUInt32(unitId, address, false, format);
    }

    public long readUInt32(int unitId, int address, boolean littleEndian, EByteBuffFormat format) {
        byte[] res = this.readHoldRegister(unitId, address, 2);
        return ByteReadBuff.newInstance(res, 0, littleEndian, format).getUInt32();
    }

    public long readInt64(int address) {
        return this.readInt64(this.unitId, address, EByteBuffFormat.BA_DC);
    }

    public long readInt64(int address, EByteBuffFormat format) {
        return this.readInt64(this.unitId, address, format);
    }

    public long readInt64(int unitId, int address) {
        return this.readInt64(unitId, address, EByteBuffFormat.BA_DC);
    }

    public long readInt64(int unitId, int address, EByteBuffFormat format) {
        return this.readInt64(unitId, address, false, format);
    }

    public long readInt64(int unitId, int address, boolean littleEndian, EByteBuffFormat format) {
        byte[] res = this.readHoldRegister(unitId, address, 4);
        return ByteReadBuff.newInstance(res, 0, littleEndian, format).getInt64();
    }

    public float readFloat32(int address) {
        return this.readFloat32(this.unitId, address, EByteBuffFormat.BA_DC);
    }

    public float readFloat32(int address, EByteBuffFormat format) {
        return this.readFloat32(this.unitId, address, format);
    }

    public float readFloat32(int unitId, int address) {
        return this.readFloat32(unitId, address, EByteBuffFormat.BA_DC);
    }

    public float readFloat32(int unitId, int address, EByteBuffFormat format) {
        return this.readFloat32(unitId, address, false, format);
    }

    public float readFloat32(int unitId, int address, boolean littleEndian, EByteBuffFormat format) {
        byte[] res = this.readHoldRegister(unitId, address, 2);
        return ByteReadBuff.newInstance(res, 0, littleEndian, format).getFloat32();
    }

    public double readFloat64(int address) {
        return this.readFloat64(this.unitId, address, EByteBuffFormat.BA_DC);
    }

    public double readFloat64(int address, EByteBuffFormat format) {
        return this.readFloat64(this.unitId, address, format);
    }

    public double readFloat64(int unitId, int address) {
        return this.readFloat64(unitId, address, EByteBuffFormat.BA_DC);
    }

    public double readFloat64(int unitId, int address, EByteBuffFormat format) {
        return this.readFloat64(unitId, address, false, format);
    }

    public double readFloat64(int unitId, int address, boolean littleEndian, EByteBuffFormat format) {
        byte[] res = this.readHoldRegister(unitId, address, 4);
        return ByteReadBuff.newInstance(res, 0, littleEndian, format).getFloat64();
    }

    public String readString(int address, int length) {
        return this.readString(this.unitId, address, length, StandardCharsets.US_ASCII);
    }

    public String readString(int address, int length, Charset charset) {
        return this.readString(this.unitId, address, length, charset);
    }

    public String readString(int unitId, int address, int length) {
        return this.readString(unitId, address, length, StandardCharsets.US_ASCII);
    }

    public String readString(int unitId, int address, int length, Charset charset) {
        byte[] res = this.readHoldRegister(unitId, address, length / 2);
        return ByteUtil.toStr(res, 0, res.length, charset);
    }

    public void writeInt16(int address, short data) {
        this.writeInt16(this.unitId, address, data, false);
    }

    public void writeInt16(int address, short data, boolean littleEndian) {
        this.writeInt16(this.unitId, address, data, littleEndian);
    }

    public void writeInt16(int unitId, int address, short data) {
        this.writeInt16(unitId, address, data, false);
    }

    public void writeInt16(int unitId, int address, short data, boolean littleEndian) {
        byte[] bytes = ByteWriteBuff.newInstance(2, littleEndian).putShort(data).getData();
        this.writeHoldRegister(unitId, address, bytes);
    }

    public void writeUInt16(int address, int data) {
        this.writeUInt16(this.unitId, address, data, false);
    }

    public void writeUInt16(int address, int data, boolean littleEndian) {
        this.writeUInt16(this.unitId, address, data, littleEndian);
    }

    public void writeUInt16(int unitId, int address, int data) {
        this.writeUInt16(unitId, address, data, false);
    }

    public void writeUInt16(int unitId, int address, int data, boolean littleEndian) {
        byte[] bytes = ByteWriteBuff.newInstance(2, littleEndian).putShort(data).getData();
        this.writeHoldRegister(unitId, address, bytes);
    }

    public void writeInt32(int address, int data) {
        this.writeInt32(this.unitId, address, data, EByteBuffFormat.BA_DC);
    }

    public void writeInt32(int address, int data, EByteBuffFormat format) {
        this.writeInt32(this.unitId, address, data, format);
    }

    public void writeInt32(int unitId, int address, int data) {
        this.writeInt32(unitId, address, data, EByteBuffFormat.BA_DC);
    }

    public void writeInt32(int unitId, int address, int data, EByteBuffFormat format) {
        this.writeInt32(unitId, address, data, false, format);
    }

    public void writeInt32(int unitId, int address, int data, boolean littleEndian, EByteBuffFormat format) {
        byte[] bytes = ByteWriteBuff.newInstance(4, littleEndian, format).putInteger(data).getData();
        this.writeHoldRegister(unitId, address, bytes);
    }

    public void writeUInt32(int address, long data) {
        this.writeUInt32(this.unitId, address, data, EByteBuffFormat.BA_DC);
    }

    public void writeUInt32(int address, long data, EByteBuffFormat format) {
        this.writeUInt32(this.unitId, address, data, format);
    }

    public void writeUInt32(int unitId, int address, long data) {
        this.writeUInt32(unitId, address, data, EByteBuffFormat.BA_DC);
    }

    public void writeUInt32(int unitId, int address, long data, EByteBuffFormat format) {
        this.writeUInt32(unitId, address, data, false, format);
    }

    public void writeUInt32(int unitId, int address, long data, boolean littleEndian, EByteBuffFormat format) {
        byte[] bytes = ByteWriteBuff.newInstance(4, littleEndian, format).putInteger(data).getData();
        this.writeHoldRegister(unitId, address, bytes);
    }

    public void writeInt64(int address, long data) {
        this.writeInt64(this.unitId, address, data, EByteBuffFormat.BA_DC);
    }

    public void writeInt64(int address, long data, EByteBuffFormat format) {
        this.writeInt64(this.unitId, address, data, format);
    }

    public void writeInt64(int unitId, int address, long data) {
        this.writeInt64(unitId, address, data, false, EByteBuffFormat.BA_DC);
    }

    public void writeInt64(int unitId, int address, long data, EByteBuffFormat format) {
        this.writeInt64(unitId, address, data, false, format);
    }

    public void writeInt64(int unitId, int address, long data, boolean littleEndian, EByteBuffFormat format) {
        byte[] bytes = ByteWriteBuff.newInstance(8, littleEndian, format).putLong(data).getData();
        this.writeHoldRegister(unitId, address, bytes);
    }

    public void writeFloat32(int address, float data) {
        this.writeFloat32(this.unitId, address, data, EByteBuffFormat.BA_DC);
    }

    public void writeFloat32(int address, float data, EByteBuffFormat format) {
        this.writeFloat32(this.unitId, address, data, format);
    }

    public void writeFloat32(int unitId, int address, float data) {
        this.writeFloat32(unitId, address, data, EByteBuffFormat.BA_DC);
    }

    public void writeFloat32(int unitId, int address, float data, EByteBuffFormat format) {
        this.writeFloat32(unitId, address, data, false, format);
    }

    public void writeFloat32(int unitId, int address, float data, boolean littleEndian, EByteBuffFormat format) {
        byte[] bytes = ByteWriteBuff.newInstance(4, littleEndian, format).putFloat(data).getData();
        this.writeHoldRegister(unitId, address, bytes);
    }

    public void writeFloat64(int address, double data) {
        this.writeFloat64(this.unitId, address, data, EByteBuffFormat.BA_DC);
    }

    public void writeFloat64(int address, double data, EByteBuffFormat format) {
        this.writeFloat64(this.unitId, address, data, format);
    }

    public void writeFloat64(int unitId, int address, double data) {
        this.writeFloat64(unitId, address, data, EByteBuffFormat.BA_DC);
    }

    public void writeFloat64(int unitId, int address, double data, EByteBuffFormat format) {
        this.writeFloat64(unitId, address, data, false, format);
    }

    public void writeFloat64(int unitId, int address, double data, boolean littleEndian, EByteBuffFormat format) {
        byte[] bytes = ByteWriteBuff.newInstance(8, littleEndian, format).putDouble(data).getData();
        this.writeHoldRegister(unitId, address, bytes);
    }

    public void writeString(int address, String data) {
        this.writeString(this.unitId, address, data, StandardCharsets.US_ASCII);
    }

    public void writeString(int address, String data, Charset charset) {
        this.writeString(this.unitId, address, data, charset);
    }

    public void writeString(int unitId, int address, String data) {
        this.writeString(unitId, address, data, StandardCharsets.US_ASCII);
    }

    public void writeString(int unitId, int address, String data, Charset charset) {
        byte[] bytes = data.getBytes(charset);
        this.writeHoldRegister(unitId, address, bytes);
    }

    public int getUnitId() {
        return this.unitId;
    }

    public ReentrantLock getLocker() {
        return this.locker;
    }

    public BiConsumer<String, byte[]> getComCallback() {
        return this.comCallback;
    }

    public boolean isPersistence() {
        return this.persistence;
    }

    public int getMaxLengthOfReadCoil() {
        return this.maxLengthOfReadCoil;
    }

    public int getMaxLengthOfWriteCoil() {
        return this.maxLengthOfWriteCoil;
    }

    public int getMaxLengthOfReadDiscreteInput() {
        return this.maxLengthOfReadDiscreteInput;
    }

    public int getMaxLengthOfReadHoldRegister() {
        return this.maxLengthOfReadHoldRegister;
    }

    public int getMaxLengthOfWriteHoldRegister() {
        return this.maxLengthOfWriteHoldRegister;
    }

    public int getMaxLengthOfReadInputRegister() {
        return this.maxLengthOfReadInputRegister;
    }

    public void setUnitId(int unitId) {
        this.unitId = unitId;
    }

    public void setComCallback(BiConsumer<String, byte[]> comCallback) {
        this.comCallback = comCallback;
    }

    public void setPersistence(boolean persistence) {
        this.persistence = persistence;
    }

    public void setMaxLengthOfReadCoil(int maxLengthOfReadCoil) {
        this.maxLengthOfReadCoil = maxLengthOfReadCoil;
    }

    public void setMaxLengthOfWriteCoil(int maxLengthOfWriteCoil) {
        this.maxLengthOfWriteCoil = maxLengthOfWriteCoil;
    }

    public void setMaxLengthOfReadDiscreteInput(int maxLengthOfReadDiscreteInput) {
        this.maxLengthOfReadDiscreteInput = maxLengthOfReadDiscreteInput;
    }

    public void setMaxLengthOfReadHoldRegister(int maxLengthOfReadHoldRegister) {
        this.maxLengthOfReadHoldRegister = maxLengthOfReadHoldRegister;
    }

    public void setMaxLengthOfWriteHoldRegister(int maxLengthOfWriteHoldRegister) {
        this.maxLengthOfWriteHoldRegister = maxLengthOfWriteHoldRegister;
    }

    public void setMaxLengthOfReadInputRegister(int maxLengthOfReadInputRegister) {
        this.maxLengthOfReadInputRegister = maxLengthOfReadInputRegister;
    }

    public String toString() {
        return "ModbusSkeletonAbstract(unitId=" + this.getUnitId() + ", locker=" + this.getLocker() + ", comCallback=" + this.getComCallback() + ", persistence=" + this.isPersistence() + ", maxLengthOfReadCoil=" + this.getMaxLengthOfReadCoil() + ", maxLengthOfWriteCoil=" + this.getMaxLengthOfWriteCoil() + ", maxLengthOfReadDiscreteInput=" + this.getMaxLengthOfReadDiscreteInput() + ", maxLengthOfReadHoldRegister=" + this.getMaxLengthOfReadHoldRegister() + ", maxLengthOfWriteHoldRegister=" + this.getMaxLengthOfWriteHoldRegister() + ", maxLengthOfReadInputRegister=" + this.getMaxLengthOfReadInputRegister() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModbusSkeletonAbstract)) {
            return false;
        }
        ModbusSkeletonAbstract other = (ModbusSkeletonAbstract)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getUnitId() != other.getUnitId()) {
            return false;
        }
        if (this.isPersistence() != other.isPersistence()) {
            return false;
        }
        if (this.getMaxLengthOfReadCoil() != other.getMaxLengthOfReadCoil()) {
            return false;
        }
        if (this.getMaxLengthOfWriteCoil() != other.getMaxLengthOfWriteCoil()) {
            return false;
        }
        if (this.getMaxLengthOfReadDiscreteInput() != other.getMaxLengthOfReadDiscreteInput()) {
            return false;
        }
        if (this.getMaxLengthOfReadHoldRegister() != other.getMaxLengthOfReadHoldRegister()) {
            return false;
        }
        if (this.getMaxLengthOfWriteHoldRegister() != other.getMaxLengthOfWriteHoldRegister()) {
            return false;
        }
        if (this.getMaxLengthOfReadInputRegister() != other.getMaxLengthOfReadInputRegister()) {
            return false;
        }
        ReentrantLock this$locker = this.getLocker();
        ReentrantLock other$locker = other.getLocker();
        if (this$locker == null ? other$locker != null : !this$locker.equals(other$locker)) {
            return false;
        }
        BiConsumer<String, byte[]> this$comCallback = this.getComCallback();
        BiConsumer<String, byte[]> other$comCallback = other.getComCallback();
        return !(this$comCallback == null ? other$comCallback != null : !this$comCallback.equals(other$comCallback));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModbusSkeletonAbstract;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getUnitId();
        result = result * 59 + (this.isPersistence() ? 79 : 97);
        result = result * 59 + this.getMaxLengthOfReadCoil();
        result = result * 59 + this.getMaxLengthOfWriteCoil();
        result = result * 59 + this.getMaxLengthOfReadDiscreteInput();
        result = result * 59 + this.getMaxLengthOfReadHoldRegister();
        result = result * 59 + this.getMaxLengthOfWriteHoldRegister();
        result = result * 59 + this.getMaxLengthOfReadInputRegister();
        ReentrantLock $locker = this.getLocker();
        result = result * 59 + ($locker == null ? 43 : $locker.hashCode());
        BiConsumer<String, byte[]> $comCallback = this.getComCallback();
        result = result * 59 + ($comCallback == null ? 43 : $comCallback.hashCode());
        return result;
    }
}

