/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.modbus.service;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.exceptions.SocketRuntimeException;
import com.github.xingshuangs.iot.net.SocketUtils;
import com.github.xingshuangs.iot.net.server.TcpServerBasic;
import com.github.xingshuangs.iot.protocol.modbus.enums.EMbExceptionCode;
import com.github.xingshuangs.iot.protocol.modbus.enums.EMbFunctionCode;
import com.github.xingshuangs.iot.protocol.modbus.model.MbErrorResponse;
import com.github.xingshuangs.iot.protocol.modbus.model.MbReadCoilRequest;
import com.github.xingshuangs.iot.protocol.modbus.model.MbReadCoilResponse;
import com.github.xingshuangs.iot.protocol.modbus.model.MbReadDiscreteInputRequest;
import com.github.xingshuangs.iot.protocol.modbus.model.MbReadDiscreteInputResponse;
import com.github.xingshuangs.iot.protocol.modbus.model.MbReadHoldRegisterRequest;
import com.github.xingshuangs.iot.protocol.modbus.model.MbReadHoldRegisterResponse;
import com.github.xingshuangs.iot.protocol.modbus.model.MbReadInputRegisterRequest;
import com.github.xingshuangs.iot.protocol.modbus.model.MbReadInputRegisterResponse;
import com.github.xingshuangs.iot.protocol.modbus.model.MbTcpRequest;
import com.github.xingshuangs.iot.protocol.modbus.model.MbTcpResponse;
import com.github.xingshuangs.iot.protocol.modbus.model.MbWriteMultipleCoilRequest;
import com.github.xingshuangs.iot.protocol.modbus.model.MbWriteMultipleCoilResponse;
import com.github.xingshuangs.iot.protocol.modbus.model.MbWriteMultipleRegisterRequest;
import com.github.xingshuangs.iot.protocol.modbus.model.MbWriteMultipleRegisterResponse;
import com.github.xingshuangs.iot.protocol.modbus.model.MbWriteSingleCoilRequest;
import com.github.xingshuangs.iot.protocol.modbus.model.MbWriteSingleCoilResponse;
import com.github.xingshuangs.iot.protocol.modbus.model.MbWriteSingleRegisterRequest;
import com.github.xingshuangs.iot.protocol.modbus.model.MbWriteSingleRegisterResponse;
import com.github.xingshuangs.iot.protocol.modbus.model.MbapHeader;
import com.github.xingshuangs.iot.utils.BooleanUtil;
import com.github.xingshuangs.iot.utils.HexUtil;
import com.github.xingshuangs.iot.utils.ShortUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusTcpServer
extends TcpServerBasic {
    private static final Logger log = LoggerFactory.getLogger(ModbusTcpServer.class);
    private ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private List<Boolean> coils = new ArrayList<Boolean>();
    private List<Boolean> discreteInputs = new ArrayList<Boolean>();
    private byte[] inputRegisters;
    private byte[] holdRegisters;
    private AtomicInteger connectedNumber = new AtomicInteger();
    private Integer maxAvailableNumber;

    public ModbusTcpServer() {
        this(502, 2000);
    }

    public ModbusTcpServer(int port) {
        this(port, 2000);
    }

    public ModbusTcpServer(int port, int size) {
        this.port = port;
        for (int i = 0; i < size; ++i) {
            this.coils.add(false);
            this.discreteInputs.add(false);
        }
        this.inputRegisters = new byte[size * 2];
        this.holdRegisters = new byte[size * 2];
        this.maxAvailableNumber = Runtime.getRuntime().availableProcessors();
    }

    @Override
    protected boolean checkClientValid(Socket client) {
        return this.connectedNumber.get() < this.maxAvailableNumber;
    }

    @Override
    protected void clientConnected(Socket socket) {
        this.connectedNumber.getAndIncrement();
    }

    @Override
    protected void clientDisconnected(Socket socket) {
        this.connectedNumber.getAndDecrement();
    }

    @Override
    protected void doClientHandle(Socket socket) {
        MbTcpRequest request = this.readModbusDataFromClient(socket);
        try {
            MbTcpResponse response;
            switch (request.getPdu().getFunctionCode()) {
                case READ_COIL: {
                    response = this.readCoil(request);
                    break;
                }
                case READ_DISCRETE_INPUT: {
                    response = this.readDiscreteInput(request);
                    break;
                }
                case READ_HOLD_REGISTER: {
                    response = this.readHoldRegister(request);
                    break;
                }
                case READ_INPUT_REGISTER: {
                    response = this.readInputRegister(request);
                    break;
                }
                case WRITE_SINGLE_COIL: {
                    response = this.writeSingleCoil(request);
                    break;
                }
                case WRITE_SINGLE_REGISTER: {
                    response = this.writeSingleRegister(request);
                    break;
                }
                case WRITE_MULTIPLE_COIL: {
                    response = this.writeMultipleCoil(request);
                    break;
                }
                case WRITE_MULTIPLE_REGISTER: {
                    response = this.writeMultipleRegister(request);
                    break;
                }
                default: {
                    EMbFunctionCode errorFunctionCode = EMbFunctionCode.from((byte)(request.getPdu().getFunctionCode().getCode() | 0xFFFFFF80));
                    response = new MbTcpResponse(request.getHeader(), new MbErrorResponse(errorFunctionCode, EMbExceptionCode.ILLEGAL_FUNCTION));
                }
            }
            this.write(socket, response.toByteArray());
        }
        catch (Exception e) {
            EMbFunctionCode errorFunctionCode = EMbFunctionCode.from((byte)(request.getPdu().getFunctionCode().getCode() | 0xFFFFFF80));
            MbTcpResponse response = new MbTcpResponse(request.getHeader(), new MbErrorResponse(errorFunctionCode, EMbExceptionCode.SLAVE_DEVICE_FAILURE));
            this.write(socket, response.toByteArray());
        }
    }

    private MbTcpRequest readModbusDataFromClient(Socket socket) {
        byte[] data = this.readClientData(socket);
        return MbTcpRequest.fromBytes(data);
    }

    @Override
    protected byte[] readClientData(Socket socket) {
        try {
            InputStream in = socket.getInputStream();
            int firstByte = in.read();
            if (firstByte == -1) {
                SocketUtils.close(socket);
                throw new SocketRuntimeException("The client is disconnected.");
            }
            byte[] headerBytes = new byte[7];
            headerBytes[0] = (byte)firstByte;
            this.read(socket, headerBytes, 1, 6, 1024, 0, true);
            MbapHeader header = MbapHeader.fromBytes(headerBytes);
            byte[] total = new byte[headerBytes.length + header.getLength() - 1];
            System.arraycopy(headerBytes, 0, total, 0, headerBytes.length);
            this.read(socket, total, headerBytes.length, header.getLength() - 1, 1024, 0, true);
            return total;
        }
        catch (IOException e) {
            throw new SocketRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MbTcpResponse readCoil(MbTcpRequest request) {
        byte[] bytes;
        MbReadCoilRequest reqPdu = (MbReadCoilRequest)request.getPdu();
        log.debug("[READ_COIL] address[{}], quantity[{}]", (Object)reqPdu.getAddress(), (Object)reqPdu.getQuantity());
        if (reqPdu.getQuantity() < 1 || reqPdu.getQuantity() > this.coils.size()) {
            return new MbTcpResponse(request.getHeader(), new MbErrorResponse(EMbFunctionCode.ERROR_READ_COIL, EMbExceptionCode.ILLEGAL_DATA_VALUE));
        }
        if (reqPdu.getAddress() < 0 || reqPdu.getAddress() > this.coils.size() - 1 || reqPdu.getAddress() + reqPdu.getQuantity() > this.coils.size() - 1) {
            return new MbTcpResponse(request.getHeader(), new MbErrorResponse(EMbFunctionCode.ERROR_READ_COIL, EMbExceptionCode.ILLEGAL_DATA_ADDRESS));
        }
        try {
            this.rwLock.readLock().lock();
            List<Boolean> booleans = this.coils.subList(reqPdu.getAddress(), reqPdu.getAddress() + reqPdu.getQuantity());
            bytes = BooleanUtil.listToByteArray(booleans);
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        MbReadCoilResponse ackPdu = new MbReadCoilResponse();
        ackPdu.setCount(bytes.length);
        ackPdu.setCoilStatus(bytes);
        return new MbTcpResponse(request.getHeader(), ackPdu);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MbTcpResponse readDiscreteInput(MbTcpRequest request) {
        byte[] bytes;
        MbReadDiscreteInputRequest reqPdu = (MbReadDiscreteInputRequest)request.getPdu();
        log.debug("[READ_DISCRETE_INPUT] address[{}], quantity[{}]", (Object)reqPdu.getAddress(), (Object)reqPdu.getQuantity());
        if (reqPdu.getQuantity() < 1 || reqPdu.getQuantity() > this.discreteInputs.size()) {
            return new MbTcpResponse(request.getHeader(), new MbErrorResponse(EMbFunctionCode.ERROR_READ_DISCRETE_INPUT, EMbExceptionCode.ILLEGAL_DATA_VALUE));
        }
        if (reqPdu.getAddress() < 0 || reqPdu.getAddress() > this.discreteInputs.size() - 1 || reqPdu.getAddress() + reqPdu.getQuantity() > this.discreteInputs.size() - 1) {
            return new MbTcpResponse(request.getHeader(), new MbErrorResponse(EMbFunctionCode.ERROR_READ_DISCRETE_INPUT, EMbExceptionCode.ILLEGAL_DATA_ADDRESS));
        }
        try {
            this.rwLock.readLock().lock();
            List<Boolean> booleans = this.discreteInputs.subList(reqPdu.getAddress(), reqPdu.getAddress() + reqPdu.getQuantity());
            bytes = BooleanUtil.listToByteArray(booleans);
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        MbReadDiscreteInputResponse ackPdu = new MbReadDiscreteInputResponse();
        ackPdu.setCount(bytes.length);
        ackPdu.setInputStatus(bytes);
        return new MbTcpResponse(request.getHeader(), ackPdu);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MbTcpResponse readHoldRegister(MbTcpRequest request) {
        byte[] bytes;
        MbReadHoldRegisterRequest reqPdu = (MbReadHoldRegisterRequest)request.getPdu();
        log.debug("[READ_HOLD_REGISTER] address[{}], quantity[{}]", (Object)reqPdu.getAddress(), (Object)reqPdu.getQuantity());
        if (reqPdu.getQuantity() < 1 || reqPdu.getQuantity() > this.holdRegisters.length / 2) {
            return new MbTcpResponse(request.getHeader(), new MbErrorResponse(EMbFunctionCode.ERROR_READ_HOLD_REGISTER, EMbExceptionCode.ILLEGAL_DATA_VALUE));
        }
        if (reqPdu.getAddress() < 0 || reqPdu.getAddress() > this.holdRegisters.length / 2 - 1 || reqPdu.getAddress() + reqPdu.getQuantity() > this.holdRegisters.length / 2 - 1) {
            return new MbTcpResponse(request.getHeader(), new MbErrorResponse(EMbFunctionCode.ERROR_READ_HOLD_REGISTER, EMbExceptionCode.ILLEGAL_DATA_ADDRESS));
        }
        try {
            this.rwLock.readLock().lock();
            ByteReadBuff buff = ByteReadBuff.newInstance(this.holdRegisters);
            bytes = buff.getBytes(reqPdu.getAddress() * 2, reqPdu.getQuantity() * 2);
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        MbReadHoldRegisterResponse ackPdu = new MbReadHoldRegisterResponse();
        ackPdu.setCount(bytes.length);
        ackPdu.setRegister(bytes);
        return new MbTcpResponse(request.getHeader(), ackPdu);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MbTcpResponse readInputRegister(MbTcpRequest request) {
        byte[] bytes;
        MbReadInputRegisterRequest reqPdu = (MbReadInputRegisterRequest)request.getPdu();
        log.debug("[READ_INPUT_REGISTER] address[{}], quantity[{}]", (Object)reqPdu.getAddress(), (Object)reqPdu.getQuantity());
        if (reqPdu.getQuantity() < 1 || reqPdu.getQuantity() > this.inputRegisters.length / 2) {
            return new MbTcpResponse(request.getHeader(), new MbErrorResponse(EMbFunctionCode.ERROR_READ_INPUT_REGISTER, EMbExceptionCode.ILLEGAL_DATA_VALUE));
        }
        if (reqPdu.getAddress() < 0 || reqPdu.getAddress() > this.inputRegisters.length / 2 - 1 || reqPdu.getAddress() + reqPdu.getQuantity() > this.inputRegisters.length / 2 - 1) {
            return new MbTcpResponse(request.getHeader(), new MbErrorResponse(EMbFunctionCode.ERROR_READ_INPUT_REGISTER, EMbExceptionCode.ILLEGAL_DATA_ADDRESS));
        }
        try {
            this.rwLock.readLock().lock();
            ByteReadBuff buff = ByteReadBuff.newInstance(this.inputRegisters);
            bytes = buff.getBytes(reqPdu.getAddress() * 2, reqPdu.getQuantity() * 2);
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        MbReadInputRegisterResponse ackPdu = new MbReadInputRegisterResponse();
        ackPdu.setCount(bytes.length);
        ackPdu.setRegister(bytes);
        return new MbTcpResponse(request.getHeader(), ackPdu);
    }

    private MbTcpResponse writeSingleCoil(MbTcpRequest request) {
        MbWriteSingleCoilRequest reqPdu = (MbWriteSingleCoilRequest)request.getPdu();
        log.debug("[WRITE_SINGLE_COIL] address[{}], value[{}]", (Object)reqPdu.getAddress(), (Object)reqPdu.isValue());
        if (reqPdu.getAddress() < 0 || reqPdu.getAddress() > this.coils.size() - 1) {
            return new MbTcpResponse(request.getHeader(), new MbErrorResponse(EMbFunctionCode.ERROR_WRITE_SINGLE_COIL, EMbExceptionCode.ILLEGAL_DATA_ADDRESS));
        }
        try {
            this.rwLock.writeLock().lock();
            this.coils.set(reqPdu.getAddress(), reqPdu.isValue());
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        MbWriteSingleCoilResponse ackPdu = new MbWriteSingleCoilResponse();
        ackPdu.setAddress(reqPdu.getAddress());
        ackPdu.setValue(new byte[]{-1, 0});
        return new MbTcpResponse(request.getHeader(), ackPdu);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MbTcpResponse writeSingleRegister(MbTcpRequest request) {
        MbWriteSingleRegisterRequest reqPdu = (MbWriteSingleRegisterRequest)request.getPdu();
        log.debug("[WRITE_SINGLE_REGISTER] address[{}], value[{}]", (Object)reqPdu.getAddress(), (Object)reqPdu.getValue());
        if (reqPdu.getValue() < 0 || reqPdu.getValue() > 65535) {
            return new MbTcpResponse(request.getHeader(), new MbErrorResponse(EMbFunctionCode.ERROR_WRITE_SINGLE_REGISTER, EMbExceptionCode.ILLEGAL_DATA_VALUE));
        }
        if (reqPdu.getAddress() < 0 || reqPdu.getAddress() > this.holdRegisters.length / 2 - 1) {
            return new MbTcpResponse(request.getHeader(), new MbErrorResponse(EMbFunctionCode.ERROR_WRITE_SINGLE_REGISTER, EMbExceptionCode.ILLEGAL_DATA_ADDRESS));
        }
        try {
            this.rwLock.writeLock().lock();
            byte[] bytes = ShortUtil.toByteArray(reqPdu.getValue());
            System.arraycopy(bytes, 0, this.holdRegisters, reqPdu.getAddress() * 2, bytes.length);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        MbWriteSingleRegisterResponse ackPdu = new MbWriteSingleRegisterResponse();
        ackPdu.setAddress(reqPdu.getAddress());
        ackPdu.setValue(new byte[]{-1, 0});
        return new MbTcpResponse(request.getHeader(), ackPdu);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MbTcpResponse writeMultipleCoil(MbTcpRequest request) {
        MbWriteMultipleCoilRequest reqPdu = (MbWriteMultipleCoilRequest)request.getPdu();
        List<Boolean> booleans = BooleanUtil.byteArrayToList(reqPdu.getQuantity(), reqPdu.getValue());
        log.debug("[WRITE_MULTIPLE_COIL] address[{}], quantity[{}], value[{}]", new Object[]{reqPdu.getAddress(), reqPdu.getQuantity(), Arrays.toString(booleans.toArray())});
        if (reqPdu.getQuantity() < 1 || reqPdu.getQuantity() > this.coils.size() || reqPdu.getCount() != reqPdu.getValue().length) {
            return new MbTcpResponse(request.getHeader(), new MbErrorResponse(EMbFunctionCode.ERROR_WRITE_MULTIPLE_COIL, EMbExceptionCode.ILLEGAL_DATA_VALUE));
        }
        if (reqPdu.getAddress() < 0 || reqPdu.getAddress() > this.coils.size() - 1 || reqPdu.getAddress() + reqPdu.getQuantity() > this.coils.size() - 1) {
            return new MbTcpResponse(request.getHeader(), new MbErrorResponse(EMbFunctionCode.ERROR_WRITE_MULTIPLE_COIL, EMbExceptionCode.ILLEGAL_DATA_ADDRESS));
        }
        try {
            this.rwLock.writeLock().lock();
            for (int i = 0; i < booleans.size(); ++i) {
                this.coils.set(reqPdu.getAddress() + i, booleans.get(i));
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        MbWriteMultipleCoilResponse ackPdu = new MbWriteMultipleCoilResponse();
        ackPdu.setAddress(reqPdu.getAddress());
        ackPdu.setQuantity(reqPdu.getQuantity());
        return new MbTcpResponse(request.getHeader(), ackPdu);
    }

    private MbTcpResponse writeMultipleRegister(MbTcpRequest request) {
        MbWriteMultipleRegisterRequest reqPdu = (MbWriteMultipleRegisterRequest)request.getPdu();
        log.debug("[WRITE_MULTIPLE_REGISTER] address[{}], quantity[{}], value[{}]", new Object[]{reqPdu.getAddress(), reqPdu.getQuantity(), HexUtil.toHexString(reqPdu.getValue())});
        if (reqPdu.getQuantity() < 1 || reqPdu.getQuantity() > this.holdRegisters.length / 2 || reqPdu.getCount() != reqPdu.getQuantity() * 2) {
            return new MbTcpResponse(request.getHeader(), new MbErrorResponse(EMbFunctionCode.ERROR_WRITE_MULTIPLE_REGISTER, EMbExceptionCode.ILLEGAL_DATA_VALUE));
        }
        if (reqPdu.getAddress() < 0 || reqPdu.getAddress() > this.holdRegisters.length / 2 - 1 || reqPdu.getAddress() + reqPdu.getQuantity() > this.holdRegisters.length / 2 - 1) {
            return new MbTcpResponse(request.getHeader(), new MbErrorResponse(EMbFunctionCode.ERROR_WRITE_MULTIPLE_REGISTER, EMbExceptionCode.ILLEGAL_DATA_ADDRESS));
        }
        try {
            this.rwLock.writeLock().lock();
            System.arraycopy(reqPdu.getValue(), 0, this.holdRegisters, reqPdu.getAddress() * 2, reqPdu.getCount());
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        MbWriteMultipleRegisterResponse ackPdu = new MbWriteMultipleRegisterResponse();
        ackPdu.setAddress(reqPdu.getAddress());
        ackPdu.setQuantity(reqPdu.getQuantity());
        return new MbTcpResponse(request.getHeader(), ackPdu);
    }

    public ReadWriteLock getRwLock() {
        return this.rwLock;
    }

    public List<Boolean> getCoils() {
        return this.coils;
    }

    public List<Boolean> getDiscreteInputs() {
        return this.discreteInputs;
    }

    public byte[] getInputRegisters() {
        return this.inputRegisters;
    }

    public byte[] getHoldRegisters() {
        return this.holdRegisters;
    }

    public AtomicInteger getConnectedNumber() {
        return this.connectedNumber;
    }

    public Integer getMaxAvailableNumber() {
        return this.maxAvailableNumber;
    }

    public void setRwLock(ReadWriteLock rwLock) {
        this.rwLock = rwLock;
    }

    public void setCoils(List<Boolean> coils) {
        this.coils = coils;
    }

    public void setDiscreteInputs(List<Boolean> discreteInputs) {
        this.discreteInputs = discreteInputs;
    }

    public void setInputRegisters(byte[] inputRegisters) {
        this.inputRegisters = inputRegisters;
    }

    public void setHoldRegisters(byte[] holdRegisters) {
        this.holdRegisters = holdRegisters;
    }

    public void setConnectedNumber(AtomicInteger connectedNumber) {
        this.connectedNumber = connectedNumber;
    }

    public void setMaxAvailableNumber(Integer maxAvailableNumber) {
        this.maxAvailableNumber = maxAvailableNumber;
    }

    @Override
    public String toString() {
        return "ModbusTcpServer(rwLock=" + this.getRwLock() + ", coils=" + this.getCoils() + ", discreteInputs=" + this.getDiscreteInputs() + ", inputRegisters=" + Arrays.toString(this.getInputRegisters()) + ", holdRegisters=" + Arrays.toString(this.getHoldRegisters()) + ", connectedNumber=" + this.getConnectedNumber() + ", maxAvailableNumber=" + this.getMaxAvailableNumber() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModbusTcpServer)) {
            return false;
        }
        ModbusTcpServer other = (ModbusTcpServer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$maxAvailableNumber = this.getMaxAvailableNumber();
        Integer other$maxAvailableNumber = other.getMaxAvailableNumber();
        if (this$maxAvailableNumber == null ? other$maxAvailableNumber != null : !((Object)this$maxAvailableNumber).equals(other$maxAvailableNumber)) {
            return false;
        }
        ReadWriteLock this$rwLock = this.getRwLock();
        ReadWriteLock other$rwLock = other.getRwLock();
        if (this$rwLock == null ? other$rwLock != null : !this$rwLock.equals(other$rwLock)) {
            return false;
        }
        List<Boolean> this$coils = this.getCoils();
        List<Boolean> other$coils = other.getCoils();
        if (this$coils == null ? other$coils != null : !((Object)this$coils).equals(other$coils)) {
            return false;
        }
        List<Boolean> this$discreteInputs = this.getDiscreteInputs();
        List<Boolean> other$discreteInputs = other.getDiscreteInputs();
        if (this$discreteInputs == null ? other$discreteInputs != null : !((Object)this$discreteInputs).equals(other$discreteInputs)) {
            return false;
        }
        if (!Arrays.equals(this.getInputRegisters(), other.getInputRegisters())) {
            return false;
        }
        if (!Arrays.equals(this.getHoldRegisters(), other.getHoldRegisters())) {
            return false;
        }
        AtomicInteger this$connectedNumber = this.getConnectedNumber();
        AtomicInteger other$connectedNumber = other.getConnectedNumber();
        return !(this$connectedNumber == null ? other$connectedNumber != null : !this$connectedNumber.equals(other$connectedNumber));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ModbusTcpServer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $maxAvailableNumber = this.getMaxAvailableNumber();
        result = result * 59 + ($maxAvailableNumber == null ? 43 : ((Object)$maxAvailableNumber).hashCode());
        ReadWriteLock $rwLock = this.getRwLock();
        result = result * 59 + ($rwLock == null ? 43 : $rwLock.hashCode());
        List<Boolean> $coils = this.getCoils();
        result = result * 59 + ($coils == null ? 43 : ((Object)$coils).hashCode());
        List<Boolean> $discreteInputs = this.getDiscreteInputs();
        result = result * 59 + ($discreteInputs == null ? 43 : ((Object)$discreteInputs).hashCode());
        result = result * 59 + Arrays.hashCode(this.getInputRegisters());
        result = result * 59 + Arrays.hashCode(this.getHoldRegisters());
        AtomicInteger $connectedNumber = this.getConnectedNumber();
        result = result * 59 + ($connectedNumber == null ? 43 : $connectedNumber.hashCode());
        return result;
    }
}

