/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.mp4.model;

import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.mp4.enums.EMp4Type;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4Box;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4TrackInfo;

public class Mp4HdlrBox
extends Mp4Box {
    private final int version;
    private final byte[] flags;
    private final byte[] preDefined;
    private final String handlerType;
    private final byte[] reserved;
    private final String name;

    public Mp4HdlrBox(Mp4TrackInfo trackInfo) {
        this.mp4Type = EMp4Type.HDLR;
        this.version = 0;
        this.flags = new byte[3];
        this.preDefined = new byte[4];
        this.reserved = new byte[12];
        this.handlerType = trackInfo.getType().equals("video") ? "vide" : "soun";
        this.name = trackInfo.getType().equals("video") ? "VideoHandler" : "SoundHandler";
    }

    @Override
    public int byteArrayLength() {
        return 32 + this.name.length() + 1;
    }

    @Override
    public byte[] toByteArray() {
        int size = this.byteArrayLength();
        return ByteWriteBuff.newInstance(size).putInteger(size).putBytes(this.mp4Type.getByteArray()).putByte(this.version).putBytes(this.flags).putBytes(this.preDefined).putString(this.handlerType).putBytes(this.reserved).putString(this.name).getData();
    }
}

