/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.mp4.model;

import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4SampleFlag;
import java.util.Arrays;

public class Mp4SampleData {
    private long dts = 0L;
    private byte[] data;
    private int size = 0;
    private int duration = 3600;
    private int cts = 0;
    private Mp4SampleFlag flags = new Mp4SampleFlag();

    public void setData(byte[] data) {
        this.size = 4 + data.length;
        ByteWriteBuff buff = new ByteWriteBuff(4 + data.length);
        buff.putInteger(data.length).putBytes(data);
        this.data = buff.getData();
    }

    public long getDts() {
        return this.dts;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getSize() {
        return this.size;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getCts() {
        return this.cts;
    }

    public Mp4SampleFlag getFlags() {
        return this.flags;
    }

    public void setDts(long dts) {
        this.dts = dts;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void setCts(int cts) {
        this.cts = cts;
    }

    public void setFlags(Mp4SampleFlag flags) {
        this.flags = flags;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Mp4SampleData)) {
            return false;
        }
        Mp4SampleData other = (Mp4SampleData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDts() != other.getDts()) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (this.getDuration() != other.getDuration()) {
            return false;
        }
        if (this.getCts() != other.getCts()) {
            return false;
        }
        if (!Arrays.equals(this.getData(), other.getData())) {
            return false;
        }
        Mp4SampleFlag this$flags = this.getFlags();
        Mp4SampleFlag other$flags = other.getFlags();
        return !(this$flags == null ? other$flags != null : !((Object)this$flags).equals(other$flags));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Mp4SampleData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $dts = this.getDts();
        result = result * 59 + (int)($dts >>> 32 ^ $dts);
        result = result * 59 + this.getSize();
        result = result * 59 + this.getDuration();
        result = result * 59 + this.getCts();
        result = result * 59 + Arrays.hashCode(this.getData());
        Mp4SampleFlag $flags = this.getFlags();
        result = result * 59 + ($flags == null ? 43 : ((Object)$flags).hashCode());
        return result;
    }

    public String toString() {
        return "Mp4SampleData(dts=" + this.getDts() + ", data=" + Arrays.toString(this.getData()) + ", size=" + this.getSize() + ", duration=" + this.getDuration() + ", cts=" + this.getCts() + ", flags=" + this.getFlags() + ")";
    }
}

