/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.mp4.model;

import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.mp4.enums.EMp4Type;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4Box;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4TrackInfo;
import com.github.xingshuangs.iot.utils.TimesUtil;
import java.time.LocalDateTime;

public class Mp4TkhdBox
extends Mp4Box {
    private final int version;
    private final byte[] flags;
    private final LocalDateTime creationTime;
    private final LocalDateTime modificationTime;
    private final int trackId;
    private final byte[] reserve1;
    private final int duration;
    private final byte[] reserve2;
    private final int layer;
    private final byte[] reserve3;
    private final int volume;
    private final byte[] reserve4;
    private final byte[] unityMatrix;
    private final int width;
    private final int height;

    public Mp4TkhdBox(Mp4TrackInfo trackInfo) {
        this.mp4Type = EMp4Type.TKHD;
        this.version = 0;
        this.flags = new byte[]{0, 0, 7};
        this.creationTime = TimesUtil.getUTCDateTime(0L);
        this.modificationTime = TimesUtil.getUTCDateTime(0L);
        this.trackId = trackInfo.getId();
        this.reserve1 = new byte[4];
        this.duration = trackInfo.getDuration();
        this.reserve2 = new byte[8];
        this.layer = trackInfo.getType().equals("video") ? 0 : 1;
        this.reserve3 = new byte[2];
        this.volume = 0;
        this.reserve4 = new byte[2];
        this.unityMatrix = new byte[]{0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 0, 0, 0};
        this.width = trackInfo.getWidth();
        this.height = trackInfo.getHeight();
    }

    @Override
    public int byteArrayLength() {
        return 92;
    }

    @Override
    public byte[] toByteArray() {
        int size = this.byteArrayLength();
        return ByteWriteBuff.newInstance(size).putInteger(size).putBytes(this.mp4Type.getByteArray()).putByte(this.version).putBytes(this.flags).putInteger(TimesUtil.getUTCTotalSecond(this.creationTime)).putInteger(TimesUtil.getUTCTotalSecond(this.modificationTime)).putInteger(this.trackId).putBytes(this.reserve1).putInteger(this.duration).putBytes(this.reserve2).putShort(this.layer).putBytes(this.reserve3).putShort(this.volume).putBytes(this.reserve4).putBytes(this.unityMatrix).putInteger(this.width << 16).putInteger(this.height << 16).getData();
    }
}

