/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.mp4.model;

import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4SampleData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Mp4TrackInfo {
    private int id;
    private String type = "video";
    private String codec = "avc1.64002a";
    private int timescale;
    private int duration;
    private int width;
    private int height;
    private byte[] sps;
    private byte[] pps;
    private int volume;
    private int audioSampleRate;
    private int channelCount;
    private byte[] config;
    private List<Mp4SampleData> sampleData = new ArrayList<Mp4SampleData>();

    public byte[] totalSampleData() {
        int sum = this.sampleData.stream().mapToInt(Mp4SampleData::getSize).sum();
        ByteWriteBuff buff = new ByteWriteBuff(sum);
        this.sampleData.forEach(x -> buff.putBytes(x.getData()));
        return buff.getData();
    }

    public int getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getCodec() {
        return this.codec;
    }

    public int getTimescale() {
        return this.timescale;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public byte[] getSps() {
        return this.sps;
    }

    public byte[] getPps() {
        return this.pps;
    }

    public int getVolume() {
        return this.volume;
    }

    public int getAudioSampleRate() {
        return this.audioSampleRate;
    }

    public int getChannelCount() {
        return this.channelCount;
    }

    public byte[] getConfig() {
        return this.config;
    }

    public List<Mp4SampleData> getSampleData() {
        return this.sampleData;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setCodec(String codec) {
        this.codec = codec;
    }

    public void setTimescale(int timescale) {
        this.timescale = timescale;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setSps(byte[] sps) {
        this.sps = sps;
    }

    public void setPps(byte[] pps) {
        this.pps = pps;
    }

    public void setVolume(int volume) {
        this.volume = volume;
    }

    public void setAudioSampleRate(int audioSampleRate) {
        this.audioSampleRate = audioSampleRate;
    }

    public void setChannelCount(int channelCount) {
        this.channelCount = channelCount;
    }

    public void setConfig(byte[] config) {
        this.config = config;
    }

    public void setSampleData(List<Mp4SampleData> sampleData) {
        this.sampleData = sampleData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Mp4TrackInfo)) {
            return false;
        }
        Mp4TrackInfo other = (Mp4TrackInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getTimescale() != other.getTimescale()) {
            return false;
        }
        if (this.getDuration() != other.getDuration()) {
            return false;
        }
        if (this.getWidth() != other.getWidth()) {
            return false;
        }
        if (this.getHeight() != other.getHeight()) {
            return false;
        }
        if (this.getVolume() != other.getVolume()) {
            return false;
        }
        if (this.getAudioSampleRate() != other.getAudioSampleRate()) {
            return false;
        }
        if (this.getChannelCount() != other.getChannelCount()) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$codec = this.getCodec();
        String other$codec = other.getCodec();
        if (this$codec == null ? other$codec != null : !this$codec.equals(other$codec)) {
            return false;
        }
        if (!Arrays.equals(this.getSps(), other.getSps())) {
            return false;
        }
        if (!Arrays.equals(this.getPps(), other.getPps())) {
            return false;
        }
        if (!Arrays.equals(this.getConfig(), other.getConfig())) {
            return false;
        }
        List<Mp4SampleData> this$sampleData = this.getSampleData();
        List<Mp4SampleData> other$sampleData = other.getSampleData();
        return !(this$sampleData == null ? other$sampleData != null : !((Object)this$sampleData).equals(other$sampleData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Mp4TrackInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + this.getTimescale();
        result = result * 59 + this.getDuration();
        result = result * 59 + this.getWidth();
        result = result * 59 + this.getHeight();
        result = result * 59 + this.getVolume();
        result = result * 59 + this.getAudioSampleRate();
        result = result * 59 + this.getChannelCount();
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $codec = this.getCodec();
        result = result * 59 + ($codec == null ? 43 : $codec.hashCode());
        result = result * 59 + Arrays.hashCode(this.getSps());
        result = result * 59 + Arrays.hashCode(this.getPps());
        result = result * 59 + Arrays.hashCode(this.getConfig());
        List<Mp4SampleData> $sampleData = this.getSampleData();
        result = result * 59 + ($sampleData == null ? 43 : ((Object)$sampleData).hashCode());
        return result;
    }

    public String toString() {
        return "Mp4TrackInfo(id=" + this.getId() + ", type=" + this.getType() + ", codec=" + this.getCodec() + ", timescale=" + this.getTimescale() + ", duration=" + this.getDuration() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", sps=" + Arrays.toString(this.getSps()) + ", pps=" + Arrays.toString(this.getPps()) + ", volume=" + this.getVolume() + ", audioSampleRate=" + this.getAudioSampleRate() + ", channelCount=" + this.getChannelCount() + ", config=" + Arrays.toString(this.getConfig()) + ", sampleData=" + this.getSampleData() + ")";
    }
}

