/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtcp.model;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.rtcp.model.RtcpBasePackage;
import com.github.xingshuangs.iot.protocol.rtcp.model.RtcpHeader;
import java.nio.charset.StandardCharsets;

public final class RtcpApp
extends RtcpBasePackage {
    private long sourceId;
    private String name;

    @Override
    public int byteArrayLength() {
        return 12;
    }

    @Override
    public byte[] toByteArray() {
        byte[] des = new byte[4];
        byte[] src = this.name.getBytes(StandardCharsets.US_ASCII);
        System.arraycopy(src, 0, des, 0, Math.min(des.length, src.length));
        return ByteWriteBuff.newInstance(12).putBytes(this.header.toByteArray()).putInteger(this.sourceId).putBytes(des).getData();
    }

    public static RtcpApp fromBytes(byte[] data) {
        return RtcpApp.fromBytes(data, 0);
    }

    public static RtcpApp fromBytes(byte[] data, int offset) {
        if (data.length < 12) {
            throw new IndexOutOfBoundsException("RtcpBye, data length < 12");
        }
        RtcpApp res = new RtcpApp();
        res.header = RtcpHeader.fromBytes(data, offset);
        ByteReadBuff buff = new ByteReadBuff(data, offset + res.header.byteArrayLength());
        res.sourceId = buff.getUInt32();
        res.name = buff.getString(4);
        return res;
    }

    public long getSourceId() {
        return this.sourceId;
    }

    public String getName() {
        return this.name;
    }

    public void setSourceId(long sourceId) {
        this.sourceId = sourceId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "RtcpApp(sourceId=" + this.getSourceId() + ", name=" + this.getName() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtcpApp)) {
            return false;
        }
        RtcpApp other = (RtcpApp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getSourceId() != other.getSourceId()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RtcpApp;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $sourceId = this.getSourceId();
        result = result * 59 + (int)($sourceId >>> 32 ^ $sourceId);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }
}

