/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtcp.model;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.rtcp.enums.ERtcpPackageType;
import com.github.xingshuangs.iot.protocol.rtcp.model.RtcpBasePackage;
import com.github.xingshuangs.iot.protocol.rtcp.model.RtcpHeader;
import com.github.xingshuangs.iot.protocol.rtcp.model.RtcpReportBlock;
import java.util.ArrayList;
import java.util.List;

public final class RtcpReceiverReport
extends RtcpBasePackage {
    private long sourceId;
    private List<RtcpReportBlock> reportBlocks = new ArrayList<RtcpReportBlock>();

    public RtcpReceiverReport() {
    }

    public RtcpReceiverReport(long sourceId) {
        this.header = new RtcpHeader();
        this.header.version = 2;
        this.header.padding = false;
        this.header.receptionCount = 0;
        this.header.packageType = ERtcpPackageType.RR;
        this.header.length = 1;
        this.sourceId = sourceId;
    }

    public void addRtcpReportBlock(RtcpReportBlock reportBlock) {
        this.reportBlocks.add(reportBlock);
        this.header.receptionCount = this.reportBlocks.size();
        this.header.length = this.byteArrayLength() / 4 - 1;
    }

    @Override
    public int byteArrayLength() {
        int length = 0;
        length += this.header != null ? this.header.byteArrayLength() : 0;
        length += 4;
        for (RtcpReportBlock block : this.reportBlocks) {
            length += block.byteArrayLength();
        }
        return length;
    }

    @Override
    public byte[] toByteArray() {
        ByteWriteBuff buff = ByteWriteBuff.newInstance(this.byteArrayLength());
        if (this.header != null) {
            buff.putBytes(this.header.toByteArray());
        }
        buff.putInteger(this.sourceId);
        for (RtcpReportBlock block : this.reportBlocks) {
            buff.putBytes(block.toByteArray());
        }
        return buff.getData();
    }

    public static RtcpReceiverReport fromBytes(byte[] data) {
        return RtcpReceiverReport.fromBytes(data, 0);
    }

    public static RtcpReceiverReport fromBytes(byte[] data, int offset) {
        if (data.length < 8) {
            throw new IndexOutOfBoundsException("RtcpReceiverReport, data length < 8");
        }
        int off = offset;
        RtcpReceiverReport res = new RtcpReceiverReport();
        res.header = RtcpHeader.fromBytes(data, off);
        res.sourceId = ByteReadBuff.newInstance(data, off += res.header.byteArrayLength()).getUInt32();
        off += 4;
        for (int i = 0; i < res.header.getReceptionCount(); ++i) {
            RtcpReportBlock reportBlock = RtcpReportBlock.fromBytes(data, off);
            res.reportBlocks.add(reportBlock);
            off += reportBlock.byteArrayLength();
        }
        return res;
    }

    public long getSourceId() {
        return this.sourceId;
    }

    public List<RtcpReportBlock> getReportBlocks() {
        return this.reportBlocks;
    }

    public void setSourceId(long sourceId) {
        this.sourceId = sourceId;
    }

    public void setReportBlocks(List<RtcpReportBlock> reportBlocks) {
        this.reportBlocks = reportBlocks;
    }

    public String toString() {
        return "RtcpReceiverReport(sourceId=" + this.getSourceId() + ", reportBlocks=" + this.getReportBlocks() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtcpReceiverReport)) {
            return false;
        }
        RtcpReceiverReport other = (RtcpReceiverReport)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getSourceId() != other.getSourceId()) {
            return false;
        }
        List<RtcpReportBlock> this$reportBlocks = this.getReportBlocks();
        List<RtcpReportBlock> other$reportBlocks = other.getReportBlocks();
        return !(this$reportBlocks == null ? other$reportBlocks != null : !((Object)this$reportBlocks).equals(other$reportBlocks));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RtcpReceiverReport;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $sourceId = this.getSourceId();
        result = result * 59 + (int)($sourceId >>> 32 ^ $sourceId);
        List<RtcpReportBlock> $reportBlocks = this.getReportBlocks();
        result = result * 59 + ($reportBlocks == null ? 43 : ((Object)$reportBlocks).hashCode());
        return result;
    }
}

