/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtcp.model;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.rtcp.model.RtcpBasePackage;
import com.github.xingshuangs.iot.protocol.rtcp.model.RtcpHeader;
import com.github.xingshuangs.iot.protocol.rtcp.model.RtcpReportBlock;
import com.github.xingshuangs.iot.protocol.rtcp.model.RtcpSenderInfo;
import java.util.ArrayList;
import java.util.List;

public final class RtcpSenderReport
extends RtcpBasePackage {
    private long sourceId;
    private RtcpSenderInfo senderInfo;
    private List<RtcpReportBlock> reportBlocks = new ArrayList<RtcpReportBlock>();

    @Override
    public int byteArrayLength() {
        int length = 0;
        length += this.header != null ? this.header.byteArrayLength() : 0;
        length += 4;
        length += this.senderInfo != null ? this.senderInfo.byteArrayLength() : 0;
        for (RtcpReportBlock block : this.reportBlocks) {
            length += block.byteArrayLength();
        }
        return length;
    }

    @Override
    public byte[] toByteArray() {
        ByteWriteBuff buff = ByteWriteBuff.newInstance(this.byteArrayLength());
        if (this.header != null) {
            buff.putBytes(this.header.toByteArray());
        }
        buff.putInteger(this.sourceId);
        if (this.senderInfo != null) {
            buff.putBytes(this.senderInfo.toByteArray());
        }
        for (RtcpReportBlock block : this.reportBlocks) {
            buff.putBytes(block.toByteArray());
        }
        return buff.getData();
    }

    public static RtcpSenderReport fromBytes(byte[] data) {
        return RtcpSenderReport.fromBytes(data, 0);
    }

    public static RtcpSenderReport fromBytes(byte[] data, int offset) {
        if (data.length < 28) {
            throw new IndexOutOfBoundsException("RtcpSenderReport, data length < 28");
        }
        int off = offset;
        RtcpSenderReport res = new RtcpSenderReport();
        res.header = RtcpHeader.fromBytes(data, off);
        res.sourceId = ByteReadBuff.newInstance(data, off += res.header.byteArrayLength()).getUInt32();
        res.senderInfo = RtcpSenderInfo.fromBytes(data, off += 4);
        off += res.senderInfo.byteArrayLength();
        for (int i = 0; i < res.header.getReceptionCount(); ++i) {
            RtcpReportBlock reportBlock = RtcpReportBlock.fromBytes(data, off);
            res.reportBlocks.add(reportBlock);
            off += reportBlock.byteArrayLength();
        }
        return res;
    }

    public long getSourceId() {
        return this.sourceId;
    }

    public RtcpSenderInfo getSenderInfo() {
        return this.senderInfo;
    }

    public List<RtcpReportBlock> getReportBlocks() {
        return this.reportBlocks;
    }

    public void setSourceId(long sourceId) {
        this.sourceId = sourceId;
    }

    public void setSenderInfo(RtcpSenderInfo senderInfo) {
        this.senderInfo = senderInfo;
    }

    public void setReportBlocks(List<RtcpReportBlock> reportBlocks) {
        this.reportBlocks = reportBlocks;
    }

    public String toString() {
        return "RtcpSenderReport(sourceId=" + this.getSourceId() + ", senderInfo=" + this.getSenderInfo() + ", reportBlocks=" + this.getReportBlocks() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtcpSenderReport)) {
            return false;
        }
        RtcpSenderReport other = (RtcpSenderReport)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getSourceId() != other.getSourceId()) {
            return false;
        }
        RtcpSenderInfo this$senderInfo = this.getSenderInfo();
        RtcpSenderInfo other$senderInfo = other.getSenderInfo();
        if (this$senderInfo == null ? other$senderInfo != null : !((Object)this$senderInfo).equals(other$senderInfo)) {
            return false;
        }
        List<RtcpReportBlock> this$reportBlocks = this.getReportBlocks();
        List<RtcpReportBlock> other$reportBlocks = other.getReportBlocks();
        return !(this$reportBlocks == null ? other$reportBlocks != null : !((Object)this$reportBlocks).equals(other$reportBlocks));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RtcpSenderReport;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $sourceId = this.getSourceId();
        result = result * 59 + (int)($sourceId >>> 32 ^ $sourceId);
        RtcpSenderInfo $senderInfo = this.getSenderInfo();
        result = result * 59 + ($senderInfo == null ? 43 : ((Object)$senderInfo).hashCode());
        List<RtcpReportBlock> $reportBlocks = this.getReportBlocks();
        result = result * 59 + ($reportBlocks == null ? 43 : ((Object)$reportBlocks).hashCode());
        return result;
    }
}

