/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtp.model;

import com.github.xingshuangs.iot.common.IObjectByteArray;
import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.utils.BooleanUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RtpHeader
implements IObjectByteArray {
    private int version;
    private boolean padding;
    private boolean extension;
    private int csrcCount;
    private boolean marker;
    private int payloadType;
    private int sequenceNumber;
    private long timestamp;
    private long ssrc;
    private List<Long> csrcList = new ArrayList<Long>();
    private int extensionHeaderId;
    private int extensionHeaderLength;
    private byte[] extensionHeaderContent = new byte[0];

    @Override
    public int byteArrayLength() {
        int sum = 12 + this.csrcCount * 4;
        if (this.extension) {
            sum += 4 + this.extensionHeaderLength;
        }
        return sum;
    }

    @Override
    public byte[] toByteArray() {
        byte first = (byte)(this.version << 6 & 0xC0 | BooleanUtil.setBit(5, this.padding) | BooleanUtil.setBit(4, this.extension) | this.csrcCount & 0xF);
        byte second = (byte)(BooleanUtil.setBit(7, this.marker) | this.payloadType & 0x7F);
        ByteWriteBuff buff = ByteWriteBuff.newInstance(this.byteArrayLength()).putByte(first).putByte(second).putShort(this.sequenceNumber).putInteger(this.timestamp).putInteger(this.ssrc);
        this.csrcList.forEach(buff::putInteger);
        if (this.extension) {
            buff.putShort(this.extensionHeaderId);
            buff.putShort(this.extensionHeaderLength);
            buff.putBytes(this.extensionHeaderContent);
        }
        return buff.getData();
    }

    public static RtpHeader fromBytes(byte[] data) {
        return RtpHeader.fromBytes(data, 0);
    }

    public static RtpHeader fromBytes(byte[] data, int offset) {
        if (data.length < 12) {
            throw new IndexOutOfBoundsException("header, data length < 12");
        }
        ByteReadBuff buff = new ByteReadBuff(data, offset);
        RtpHeader res = new RtpHeader();
        byte aByte = buff.getByte();
        res.version = aByte >> 6 & 3;
        res.padding = BooleanUtil.getValue(aByte, 5);
        res.extension = BooleanUtil.getValue(aByte, 4);
        res.csrcCount = aByte & 0xF;
        byte bByte = buff.getByte();
        res.marker = BooleanUtil.getValue(bByte, 7);
        res.payloadType = bByte & 0x7F;
        res.sequenceNumber = buff.getUInt16();
        res.timestamp = buff.getUInt32();
        res.ssrc = buff.getUInt32();
        for (int i = 0; i < res.csrcCount; ++i) {
            res.csrcList.add(buff.getUInt32());
        }
        if (res.extension) {
            res.extensionHeaderId = buff.getUInt16();
            res.extensionHeaderLength = buff.getUInt16() * 4;
            res.extensionHeaderContent = buff.getBytes(res.extensionHeaderLength);
        }
        return res;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isPadding() {
        return this.padding;
    }

    public boolean isExtension() {
        return this.extension;
    }

    public int getCsrcCount() {
        return this.csrcCount;
    }

    public boolean isMarker() {
        return this.marker;
    }

    public int getPayloadType() {
        return this.payloadType;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getSsrc() {
        return this.ssrc;
    }

    public List<Long> getCsrcList() {
        return this.csrcList;
    }

    public int getExtensionHeaderId() {
        return this.extensionHeaderId;
    }

    public int getExtensionHeaderLength() {
        return this.extensionHeaderLength;
    }

    public byte[] getExtensionHeaderContent() {
        return this.extensionHeaderContent;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setPadding(boolean padding) {
        this.padding = padding;
    }

    public void setExtension(boolean extension) {
        this.extension = extension;
    }

    public void setCsrcCount(int csrcCount) {
        this.csrcCount = csrcCount;
    }

    public void setMarker(boolean marker) {
        this.marker = marker;
    }

    public void setPayloadType(int payloadType) {
        this.payloadType = payloadType;
    }

    public void setSequenceNumber(int sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setSsrc(long ssrc) {
        this.ssrc = ssrc;
    }

    public void setCsrcList(List<Long> csrcList) {
        this.csrcList = csrcList;
    }

    public void setExtensionHeaderId(int extensionHeaderId) {
        this.extensionHeaderId = extensionHeaderId;
    }

    public void setExtensionHeaderLength(int extensionHeaderLength) {
        this.extensionHeaderLength = extensionHeaderLength;
    }

    public void setExtensionHeaderContent(byte[] extensionHeaderContent) {
        this.extensionHeaderContent = extensionHeaderContent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtpHeader)) {
            return false;
        }
        RtpHeader other = (RtpHeader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        if (this.isPadding() != other.isPadding()) {
            return false;
        }
        if (this.isExtension() != other.isExtension()) {
            return false;
        }
        if (this.getCsrcCount() != other.getCsrcCount()) {
            return false;
        }
        if (this.isMarker() != other.isMarker()) {
            return false;
        }
        if (this.getPayloadType() != other.getPayloadType()) {
            return false;
        }
        if (this.getSequenceNumber() != other.getSequenceNumber()) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        if (this.getSsrc() != other.getSsrc()) {
            return false;
        }
        if (this.getExtensionHeaderId() != other.getExtensionHeaderId()) {
            return false;
        }
        if (this.getExtensionHeaderLength() != other.getExtensionHeaderLength()) {
            return false;
        }
        List<Long> this$csrcList = this.getCsrcList();
        List<Long> other$csrcList = other.getCsrcList();
        if (this$csrcList == null ? other$csrcList != null : !((Object)this$csrcList).equals(other$csrcList)) {
            return false;
        }
        return Arrays.equals(this.getExtensionHeaderContent(), other.getExtensionHeaderContent());
    }

    protected boolean canEqual(Object other) {
        return other instanceof RtpHeader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getVersion();
        result = result * 59 + (this.isPadding() ? 79 : 97);
        result = result * 59 + (this.isExtension() ? 79 : 97);
        result = result * 59 + this.getCsrcCount();
        result = result * 59 + (this.isMarker() ? 79 : 97);
        result = result * 59 + this.getPayloadType();
        result = result * 59 + this.getSequenceNumber();
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        long $ssrc = this.getSsrc();
        result = result * 59 + (int)($ssrc >>> 32 ^ $ssrc);
        result = result * 59 + this.getExtensionHeaderId();
        result = result * 59 + this.getExtensionHeaderLength();
        List<Long> $csrcList = this.getCsrcList();
        result = result * 59 + ($csrcList == null ? 43 : ((Object)$csrcList).hashCode());
        result = result * 59 + Arrays.hashCode(this.getExtensionHeaderContent());
        return result;
    }

    public String toString() {
        return "RtpHeader(version=" + this.getVersion() + ", padding=" + this.isPadding() + ", extension=" + this.isExtension() + ", csrcCount=" + this.getCsrcCount() + ", marker=" + this.isMarker() + ", payloadType=" + this.getPayloadType() + ", sequenceNumber=" + this.getSequenceNumber() + ", timestamp=" + this.getTimestamp() + ", ssrc=" + this.getSsrc() + ", csrcList=" + this.getCsrcList() + ", extensionHeaderId=" + this.getExtensionHeaderId() + ", extensionHeaderLength=" + this.getExtensionHeaderLength() + ", extensionHeaderContent=" + Arrays.toString(this.getExtensionHeaderContent()) + ")";
    }
}

