/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtp.model;

import com.github.xingshuangs.iot.common.IObjectByteArray;
import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.rtp.model.RtpHeader;
import java.util.Arrays;

public class RtpPackage
implements IObjectByteArray {
    private RtpHeader header;
    private byte[] payload;
    private int ignoreLength;

    @Override
    public int byteArrayLength() {
        return this.header.byteArrayLength() + this.payload.length + this.ignoreLength;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(this.byteArrayLength()).putBytes(this.header.toByteArray()).putBytes(this.payload).getData();
    }

    public static RtpPackage fromBytes(byte[] data) {
        return RtpPackage.fromBytes(data, 0);
    }

    public static RtpPackage fromBytes(byte[] data, int offset) {
        if (data.length < 12) {
            throw new IndexOutOfBoundsException("RtpPackage, data length < 12");
        }
        int index = offset;
        RtpPackage res = new RtpPackage();
        res.header = RtpHeader.fromBytes(data, offset);
        res.ignoreLength = res.header.isPadding() ? data[data.length - 1] & 0xFF : 0;
        ByteReadBuff buff = new ByteReadBuff(data, index += res.header.byteArrayLength());
        int payloadLength = data.length - index - res.ignoreLength;
        res.payload = buff.getBytes(payloadLength);
        return res;
    }

    public RtpHeader getHeader() {
        return this.header;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public int getIgnoreLength() {
        return this.ignoreLength;
    }

    public void setHeader(RtpHeader header) {
        this.header = header;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    public void setIgnoreLength(int ignoreLength) {
        this.ignoreLength = ignoreLength;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtpPackage)) {
            return false;
        }
        RtpPackage other = (RtpPackage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIgnoreLength() != other.getIgnoreLength()) {
            return false;
        }
        RtpHeader this$header = this.getHeader();
        RtpHeader other$header = other.getHeader();
        if (this$header == null ? other$header != null : !((Object)this$header).equals(other$header)) {
            return false;
        }
        return Arrays.equals(this.getPayload(), other.getPayload());
    }

    protected boolean canEqual(Object other) {
        return other instanceof RtpPackage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIgnoreLength();
        RtpHeader $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : ((Object)$header).hashCode());
        result = result * 59 + Arrays.hashCode(this.getPayload());
        return result;
    }

    public String toString() {
        return "RtpPackage(header=" + this.getHeader() + ", payload=" + Arrays.toString(this.getPayload()) + ", ignoreLength=" + this.getIgnoreLength() + ")";
    }
}

