/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtp.model.frame;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.rtp.enums.EFrameType;
import com.github.xingshuangs.iot.protocol.rtp.enums.EH264NaluType;
import com.github.xingshuangs.iot.protocol.rtp.enums.EH264SliceType;
import com.github.xingshuangs.iot.protocol.rtp.model.frame.RawFrame;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.ExpGolomb;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluBuilder;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluSingle;

public class H264VideoFrame
extends RawFrame {
    public static final byte[] START_MARKER = new byte[]{0, 0, 0, 1};
    private final EH264NaluType naluType;
    private EH264SliceType sliceType;

    public H264VideoFrame(EH264NaluType naluType, long timestamp, byte[] frameSegment) {
        this.frameType = EFrameType.VIDEO;
        this.naluType = naluType;
        this.timestamp = timestamp;
        this.pts = timestamp;
        this.dts = timestamp;
        this.frameSegment = frameSegment;
        if (naluType == EH264NaluType.IDR_SLICE || naluType == EH264NaluType.NON_IDR_SLICE) {
            ByteReadBuff buff = ByteReadBuff.newInstance(frameSegment);
            buff.getByte();
            ExpGolomb expGolomb = new ExpGolomb(buff.getBytes());
            expGolomb.readUE();
            int type = expGolomb.readUE();
            this.sliceType = EH264SliceType.from(type % 5);
        }
    }

    @Override
    public int byteArrayLength() {
        return 6 + this.frameSegment.length;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(this.byteArrayLength()).putByte(this.frameType.getCode()).putByte(this.naluType.getCode()).putInteger(this.timestamp).putBytes(this.frameSegment).getData();
    }

    public static H264VideoFrame createSpsPpsFrame(byte[] frameSegment) {
        H264NaluSingle naluSingle = (H264NaluSingle)H264NaluBuilder.parsePackage(frameSegment);
        return new H264VideoFrame(naluSingle.getHeader().getType(), System.currentTimeMillis(), naluSingle.toByteArray());
    }

    public EH264NaluType getNaluType() {
        return this.naluType;
    }

    public EH264SliceType getSliceType() {
        return this.sliceType;
    }

    public void setSliceType(EH264SliceType sliceType) {
        this.sliceType = sliceType;
    }

    public String toString() {
        return "H264VideoFrame(naluType=" + (Object)((Object)this.getNaluType()) + ", sliceType=" + (Object)((Object)this.getSliceType()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof H264VideoFrame)) {
            return false;
        }
        H264VideoFrame other = (H264VideoFrame)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EH264NaluType this$naluType = this.getNaluType();
        EH264NaluType other$naluType = other.getNaluType();
        if (this$naluType == null ? other$naluType != null : !((Object)((Object)this$naluType)).equals((Object)other$naluType)) {
            return false;
        }
        EH264SliceType this$sliceType = this.getSliceType();
        EH264SliceType other$sliceType = other.getSliceType();
        return !(this$sliceType == null ? other$sliceType != null : !((Object)((Object)this$sliceType)).equals((Object)other$sliceType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof H264VideoFrame;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        EH264NaluType $naluType = this.getNaluType();
        result = result * 59 + ($naluType == null ? 43 : ((Object)((Object)$naluType)).hashCode());
        EH264SliceType $sliceType = this.getSliceType();
        result = result * 59 + ($sliceType == null ? 43 : ((Object)((Object)$sliceType)).hashCode());
        return result;
    }
}

