/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtp.model.payload;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluBase;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluFuHeader;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluHeader;
import java.util.Arrays;

public class H264NaluFuA
extends H264NaluBase {
    private H264NaluFuHeader fuHeader = new H264NaluFuHeader();
    protected byte[] payload = new byte[0];

    @Override
    public int byteArrayLength() {
        return this.header.byteArrayLength() + this.fuHeader.byteArrayLength() + this.payload.length;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(this.byteArrayLength()).putBytes(this.header.toByteArray()).putBytes(this.fuHeader.toByteArray()).putBytes(this.payload).getData();
    }

    public static H264NaluFuA fromBytes(byte[] data) {
        return H264NaluFuA.fromBytes(data, 0);
    }

    public static H264NaluFuA fromBytes(byte[] data, int offset) {
        if (data.length < 1) {
            throw new IndexOutOfBoundsException("H264NaluSingle, data length < 1");
        }
        H264NaluFuA res = new H264NaluFuA();
        int index = offset;
        res.header = H264NaluHeader.fromBytes(data, index);
        res.fuHeader = H264NaluFuHeader.fromBytes(data, index += res.header.byteArrayLength());
        ByteReadBuff buff = new ByteReadBuff(data, index += res.fuHeader.byteArrayLength());
        res.payload = buff.getBytes();
        return res;
    }

    public H264NaluFuHeader getFuHeader() {
        return this.fuHeader;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setFuHeader(H264NaluFuHeader fuHeader) {
        this.fuHeader = fuHeader;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    @Override
    public String toString() {
        return "H264NaluFuA(fuHeader=" + this.getFuHeader() + ", payload=" + Arrays.toString(this.getPayload()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof H264NaluFuA)) {
            return false;
        }
        H264NaluFuA other = (H264NaluFuA)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        H264NaluFuHeader this$fuHeader = this.getFuHeader();
        H264NaluFuHeader other$fuHeader = other.getFuHeader();
        if (this$fuHeader == null ? other$fuHeader != null : !((Object)this$fuHeader).equals(other$fuHeader)) {
            return false;
        }
        return Arrays.equals(this.getPayload(), other.getPayload());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof H264NaluFuA;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        H264NaluFuHeader $fuHeader = this.getFuHeader();
        result = result * 59 + ($fuHeader == null ? 43 : ((Object)$fuHeader).hashCode());
        result = result * 59 + Arrays.hashCode(this.getPayload());
        return result;
    }
}

