/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtp.model.payload;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluBase;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluHeader;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluMtap16Single;
import java.util.ArrayList;
import java.util.List;

public class H264NaluMtap16
extends H264NaluBase {
    private int decodingOrderNumber;
    private final List<H264NaluMtap16Single> naluSingles = new ArrayList<H264NaluMtap16Single>();

    @Override
    public int byteArrayLength() {
        int sum = this.header.byteArrayLength();
        sum += 2;
        for (H264NaluMtap16Single item : this.naluSingles) {
            sum += item.byteArrayLength();
        }
        return sum;
    }

    @Override
    public byte[] toByteArray() {
        ByteWriteBuff buff = ByteWriteBuff.newInstance(this.byteArrayLength());
        buff.putBytes(this.header.toByteArray());
        buff.putShort(this.decodingOrderNumber);
        for (H264NaluMtap16Single item : this.naluSingles) {
            buff.putBytes(item.toByteArray());
        }
        return buff.getData();
    }

    public static H264NaluMtap16 fromBytes(byte[] data) {
        return H264NaluMtap16.fromBytes(data, 0);
    }

    public static H264NaluMtap16 fromBytes(byte[] data, int offset) {
        if (data.length < 3) {
            throw new IndexOutOfBoundsException("H264NaluStapSingle, data length < 3");
        }
        int index = offset;
        H264NaluMtap16 res = new H264NaluMtap16();
        res.header = H264NaluHeader.fromBytes(data, index);
        res.decodingOrderNumber = ByteReadBuff.newInstance(data, index += res.header.byteArrayLength()).getUInt16();
        index += 2;
        while (index < data.length) {
            H264NaluMtap16Single tmp = H264NaluMtap16Single.fromBytes(data, index);
            res.naluSingles.add(tmp);
            index += tmp.byteArrayLength();
        }
        return res;
    }
}

