/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtp.model.payload;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluHeader;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluSingle;

public class H264NaluMtap16Single
extends H264NaluSingle {
    private int size;
    private int dond;
    private int tsOffset;

    @Override
    public int byteArrayLength() {
        return this.header.byteArrayLength() + 2 + this.payload.length;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(this.byteArrayLength()).putShort(this.size).putByte(this.dond).putShort(this.tsOffset).putBytes(this.header.toByteArray()).putBytes(this.payload).getData();
    }

    public static H264NaluMtap16Single fromBytes(byte[] data) {
        return H264NaluMtap16Single.fromBytes(data, 0);
    }

    public static H264NaluMtap16Single fromBytes(byte[] data, int offset) {
        if (data.length < 3) {
            throw new IndexOutOfBoundsException("H264NaluStapSingle, data length < 3");
        }
        int index = offset;
        ByteReadBuff buff = ByteReadBuff.newInstance(data, index);
        H264NaluMtap16Single res = new H264NaluMtap16Single();
        res.size = buff.getUInt16();
        res.dond = buff.getByteToInt();
        res.tsOffset = buff.getUInt16();
        res.header = H264NaluHeader.fromBytes(data, index += 5);
        res.payload = ByteReadBuff.newInstance(data, index += res.header.byteArrayLength()).getBytes(res.size);
        return res;
    }
}

