/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtp.model.payload;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluBase;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluHeader;
import java.util.Arrays;

public class H264NaluSingle
extends H264NaluBase {
    protected byte[] payload;

    @Override
    public int byteArrayLength() {
        return this.header.byteArrayLength() + this.payload.length;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(this.byteArrayLength()).putBytes(this.header.toByteArray()).putBytes(this.payload).getData();
    }

    public static H264NaluSingle fromBytes(byte[] data) {
        return H264NaluSingle.fromBytes(data, 0);
    }

    public static H264NaluSingle fromBytes(byte[] data, int offset) {
        if (data.length < 1) {
            throw new IndexOutOfBoundsException("H264NaluSingle, data length < 1");
        }
        H264NaluSingle res = new H264NaluSingle();
        int index = offset;
        res.header = H264NaluHeader.fromBytes(data, index);
        ByteReadBuff buff = new ByteReadBuff(data, index += res.header.byteArrayLength());
        res.payload = buff.getBytes();
        return res;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    @Override
    public String toString() {
        return "H264NaluSingle(payload=" + Arrays.toString(this.getPayload()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof H264NaluSingle)) {
            return false;
        }
        H264NaluSingle other = (H264NaluSingle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.equals(this.getPayload(), other.getPayload());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof H264NaluSingle;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.hashCode(this.getPayload());
        return result;
    }
}

