/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtp.model.payload;

import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluBase;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluHeader;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluStapSingle;
import java.util.ArrayList;
import java.util.List;

public class H264NaluStapA
extends H264NaluBase {
    private final List<H264NaluStapSingle> naluSingles = new ArrayList<H264NaluStapSingle>();

    @Override
    public int byteArrayLength() {
        int sum = this.header.byteArrayLength();
        for (H264NaluStapSingle item : this.naluSingles) {
            sum += item.byteArrayLength();
        }
        return sum;
    }

    @Override
    public byte[] toByteArray() {
        ByteWriteBuff buff = ByteWriteBuff.newInstance(this.byteArrayLength());
        buff.putBytes(this.header.toByteArray());
        for (H264NaluStapSingle item : this.naluSingles) {
            buff.putBytes(item.toByteArray());
        }
        return buff.getData();
    }

    public static H264NaluStapA fromBytes(byte[] data) {
        return H264NaluStapA.fromBytes(data, 0);
    }

    public static H264NaluStapA fromBytes(byte[] data, int offset) {
        if (data.length < 1) {
            throw new IndexOutOfBoundsException("H264NaluStapSingle, data length < 1");
        }
        int index = offset;
        H264NaluStapA res = new H264NaluStapA();
        res.header = H264NaluHeader.fromBytes(data, index);
        index += res.header.byteArrayLength();
        while (index < data.length) {
            H264NaluStapSingle tmp = H264NaluStapSingle.fromBytes(data, index);
            res.naluSingles.add(tmp);
            index += tmp.byteArrayLength();
        }
        return res;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof H264NaluStapA)) {
            return false;
        }
        H264NaluStapA other = (H264NaluStapA)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<H264NaluStapSingle> this$naluSingles = this.getNaluSingles();
        List<H264NaluStapSingle> other$naluSingles = other.getNaluSingles();
        return !(this$naluSingles == null ? other$naluSingles != null : !((Object)this$naluSingles).equals(other$naluSingles));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof H264NaluStapA;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<H264NaluStapSingle> $naluSingles = this.getNaluSingles();
        result = result * 59 + ($naluSingles == null ? 43 : ((Object)$naluSingles).hashCode());
        return result;
    }

    public List<H264NaluStapSingle> getNaluSingles() {
        return this.naluSingles;
    }

    @Override
    public String toString() {
        return "H264NaluStapA(naluSingles=" + this.getNaluSingles() + ")";
    }
}

