/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtsp.authentication;

import com.github.xingshuangs.iot.exceptions.AuthenticationException;
import com.github.xingshuangs.iot.protocol.rtsp.authentication.AbstractAuthenticator;
import com.github.xingshuangs.iot.protocol.rtsp.authentication.UsernamePasswordCredential;
import com.github.xingshuangs.iot.utils.MD5Util;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.UUID;

public class DigestAuthenticator
extends AbstractAuthenticator {
    private static final String DIGEST_NAME = "Digest";
    private String realm = "";
    private String qop = "";
    private String nonce = "";
    private int nc = 0;
    private String cnonce = "";
    private boolean stale = false;
    private String uri = "";
    private String method = "";
    private byte[] entityBody = new byte[0];

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public DigestAuthenticator(UsernamePasswordCredential credential) {
        this.credential = credential;
        this.name = DIGEST_NAME;
    }

    @Override
    public String createResponse() {
        if (this.realm == null || this.realm.equals("")) {
            throw new AuthenticationException("realm is empty");
        }
        if (this.nonce == null || this.nonce.equals("")) {
            throw new AuthenticationException("nonce is empty");
        }
        if (this.uri == null || this.uri.equals("")) {
            throw new AuthenticationException("uri is empty");
        }
        if (this.method == null || this.method.equals("")) {
            throw new AuthenticationException("method is empty");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(DIGEST_NAME).append(" ").append("username=\"").append(this.credential.getUsername()).append("\", ").append("realm=\"").append(this.realm).append("\", ").append("nonce=\"").append(this.nonce).append("\", ").append("uri=\"").append(this.uri).append("\", ");
        if (this.qop == null || this.qop.equals("")) {
            sb.append("response=\"").append(this.calculateResponseString()).append("\"");
        } else {
            sb.append("response=\"").append(this.calculateResponseString()).append("\", ").append("qop=").append(this.qop).append(", ").append("nc=").append(String.format("%08X", this.nc)).append(", ").append("cnonce=\"").append(this.cnonce).append("\"");
        }
        return sb.toString();
    }

    private String calculateResponseString() {
        try {
            ++this.nc;
            String a1 = String.format("%s:%s:%s", this.credential.getUsername(), this.realm, this.credential.getPassword());
            String ha1 = MD5Util.encode(a1);
            String a2 = String.format("%s:%s", this.method, this.uri);
            if ("auth-int".equals(this.qop)) {
                a2 = a2 + String.format(":%s", MD5Util.encode(this.entityBody));
            }
            String ha2 = MD5Util.encode(a2);
            if (this.qop == null || this.qop.equals("")) {
                String response = String.format("%s:%s:%s", ha1, this.nonce, ha2);
                return MD5Util.encode(response);
            }
            String ncStr = String.format("%08X", this.nc);
            String response = String.format("%s:%s:%s:%s:%s:%s", ha1, this.nonce, ncStr, this.cnonce, this.qop, ha2);
            return MD5Util.encode(response);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AuthenticationException(e);
        }
    }

    public void addServerInfo(String realm, String qop, String nonce, boolean stale) {
        this.realm = realm;
        this.qop = qop;
        this.nonce = nonce;
        this.stale = stale;
        this.nc = 0;
    }

    public void addServerInfoByString(String src) {
        String[] contentSplit;
        int i = src.indexOf(" ");
        if (i < 0) {
            throw new AuthenticationException("the format of the incoming server Digest data is incorrect");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String content = src.substring(i + 1);
        for (String item : contentSplit = content.split(",")) {
            int index = item.indexOf("=");
            if (index < 0) continue;
            map.put(item.substring(0, index).trim(), item.substring(index + 1).replace("\"", "").trim());
        }
        this.realm = map.getOrDefault("realm", "").trim();
        this.qop = map.getOrDefault("qop", "").trim();
        this.nonce = map.getOrDefault("nonce", "").trim();
        this.stale = map.containsKey("stale") && ((String)map.get("stale")).equals("FALSE");
        this.nc = 0;
    }

    public void addClientInfo(String uri, String method) {
        String randomStr = UUID.randomUUID().toString().replace("-", "");
        this.addClientInfo(uri, method, randomStr, new byte[0]);
    }

    public void addClientInfo(String uri, String method, String cnonce) {
        this.addClientInfo(uri, method, cnonce, new byte[0]);
    }

    public void addClientInfo(String uri, String method, String cnonce, byte[] entityBody) {
        this.uri = uri;
        this.cnonce = cnonce;
        this.method = method;
        this.entityBody = entityBody;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getQop() {
        return this.qop;
    }

    public String getNonce() {
        return this.nonce;
    }

    public int getNc() {
        return this.nc;
    }

    public String getCnonce() {
        return this.cnonce;
    }

    public boolean isStale() {
        return this.stale;
    }

    public String getUri() {
        return this.uri;
    }

    public String getMethod() {
        return this.method;
    }

    public byte[] getEntityBody() {
        return this.entityBody;
    }
}

