/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtsp.model;

import com.github.xingshuangs.iot.protocol.rtsp.authentication.AbstractAuthenticator;
import com.github.xingshuangs.iot.protocol.rtsp.enums.ERtspAcceptContent;
import com.github.xingshuangs.iot.protocol.rtsp.enums.ERtspMethod;
import com.github.xingshuangs.iot.protocol.rtsp.model.RtspMessageRequest;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class RtspDescribeRequest
extends RtspMessageRequest {
    private List<ERtspAcceptContent> acceptContents = new ArrayList<ERtspAcceptContent>();

    public RtspDescribeRequest(URI uri) {
        super(ERtspMethod.DESCRIBE, uri);
    }

    public RtspDescribeRequest(URI uri, List<ERtspAcceptContent> acceptContents) {
        super(ERtspMethod.DESCRIBE, uri);
        this.acceptContents = acceptContents;
    }

    public RtspDescribeRequest(URI uri, List<ERtspAcceptContent> acceptContents, AbstractAuthenticator authenticator) {
        super(ERtspMethod.DESCRIBE, uri, authenticator);
        this.acceptContents = acceptContents;
    }

    @Override
    protected void addRequestHeader(StringBuilder sb) {
        if (!this.acceptContents.isEmpty()) {
            sb.append("Accept").append(": ").append(this.acceptContents.stream().map(ERtspAcceptContent::getCode).collect(Collectors.joining(","))).append("\r\n");
        }
    }

    public List<ERtspAcceptContent> getAcceptContents() {
        return this.acceptContents;
    }
}

