/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtsp.model;

import com.github.xingshuangs.iot.protocol.rtsp.authentication.AbstractAuthenticator;
import com.github.xingshuangs.iot.protocol.rtsp.enums.ERtspContentType;
import com.github.xingshuangs.iot.protocol.rtsp.enums.ERtspMethod;
import com.github.xingshuangs.iot.protocol.rtsp.model.RtspMessageRequest;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public final class RtspGetParameterRequest
extends RtspMessageRequest {
    private final Set<String> parameterNames = new LinkedHashSet<String>();

    public RtspGetParameterRequest(URI uri, String session) {
        super(ERtspMethod.GET_PARAMETER, uri, session);
    }

    public RtspGetParameterRequest(URI uri, String session, AbstractAuthenticator authenticator) {
        super(ERtspMethod.GET_PARAMETER, uri, session, authenticator);
    }

    public void addParameter(String name) {
        this.parameterNames.add(name);
    }

    public void removeParameter(String name) {
        this.parameterNames.remove(name);
    }

    public Set<String> getParameters() {
        return Collections.unmodifiableSet(this.parameterNames);
    }

    @Override
    protected void addEntityHeader(StringBuilder sb) {
        if (!this.parameterNames.isEmpty()) {
            String names = String.join((CharSequence)"\r\n", this.parameterNames) + "\r\n";
            sb.append("Content-Type").append(": ").append(ERtspContentType.PARAMETER.getCode()).append("\r\n");
            sb.append("Content-Length").append(": ").append(names.length()).append("\r\n");
        }
    }

    @Override
    protected void addMessageBody(StringBuilder sb) {
        if (!this.parameterNames.isEmpty()) {
            String names = String.join((CharSequence)"\r\n", this.parameterNames) + "\r\n";
            sb.append(names);
        }
    }

    public Set<String> getParameterNames() {
        return this.parameterNames;
    }
}

