/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtsp.model;

import com.github.xingshuangs.iot.common.IObjectString;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class RtspMessage
implements IObjectString {
    public static final String VERSION_1_0 = "RTSP/1.0";
    private static final AtomicInteger index = new AtomicInteger();
    protected String version;
    protected int cSeq;
    protected String session = "";
    protected Map<String, String> headers;

    public RtspMessage() {
        this(VERSION_1_0, new HashMap<String, String>());
    }

    public RtspMessage(String version, Map<String, String> headers) {
        this.version = version;
        this.headers = headers;
    }

    @Override
    public String toObjectString() {
        StringBuilder sb = new StringBuilder();
        sb.append(VERSION_1_0).append("\r\n");
        sb.append("CSeq").append(":").append(this.cSeq).append("\r\n");
        if (this.session != null && !this.session.equals("")) {
            sb.append("Session").append(":").append(this.session).append("\r\n");
        }
        return sb.toString();
    }

    public static int getUint16Number() {
        return RtspMessage.getNumber(65536);
    }

    public static int getNumber(int max) {
        int res = index.getAndIncrement();
        if (res >= max) {
            index.set(0);
            res = 0;
        }
        return res;
    }

    public String getVersion() {
        return this.version;
    }

    public int getCSeq() {
        return this.cSeq;
    }

    public String getSession() {
        return this.session;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setCSeq(int cSeq) {
        this.cSeq = cSeq;
    }

    public void setSession(String session) {
        this.session = session;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }
}

