/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtsp.model;

import com.github.xingshuangs.iot.protocol.rtsp.enums.ERtspContentType;
import com.github.xingshuangs.iot.protocol.rtsp.enums.ERtspStatusCode;
import com.github.xingshuangs.iot.protocol.rtsp.model.RtspMessage;
import com.github.xingshuangs.iot.utils.StringSpUtil;
import java.util.Map;

public class RtspMessageResponse
extends RtspMessage {
    protected ERtspStatusCode statusCode = ERtspStatusCode.OK;
    protected String wwwAuthenticate = "";
    protected ERtspContentType contentType;
    protected String contentBase;
    protected Integer contentLength = -1;
    protected String cacheControl;

    public RtspMessageResponse() {
    }

    public RtspMessageResponse(ERtspStatusCode statusCode) {
        this.statusCode = statusCode;
    }

    public RtspMessageResponse(String version, Map<String, String> headers, ERtspStatusCode statusCode) {
        super(version, headers);
        this.statusCode = statusCode;
    }

    public Map<String, String> parseHeaderAndReturnMap(String src) {
        int startIndex = src.indexOf("\r\n");
        int endIndex = src.indexOf("\r\n\r\n");
        this.extractVersionAndStatusCode(src.substring(0, startIndex));
        String headerStr = src.substring(startIndex, endIndex + 4);
        Map<String, String> map = StringSpUtil.splitTwoStepByLine(headerStr, "\r\n", ":");
        this.extractResponseHeader(map);
        this.extractBodyHeader(map);
        return map;
    }

    private void extractVersionAndStatusCode(String src) {
        String[] versionContent = src.split(" ");
        this.version = versionContent[0].trim();
        this.statusCode = ERtspStatusCode.from(Integer.parseInt(versionContent[1].trim()));
    }

    private void extractResponseHeader(Map<String, String> map) {
        if (map.containsKey("CSeq")) {
            this.cSeq = Integer.parseInt(map.get("CSeq").trim());
        }
        if (map.containsKey("Cseq")) {
            this.cSeq = Integer.parseInt(map.get("Cseq").trim());
        }
        if (map.containsKey("WWW-Authenticate")) {
            this.wwwAuthenticate = map.getOrDefault("WWW-Authenticate", "").trim();
        }
    }

    private void extractBodyHeader(Map<String, String> map) {
        this.contentType = map.containsKey("Content-Type") ? ERtspContentType.from(map.get("Content-Type")) : null;
        this.contentBase = map.getOrDefault("Content-Base", "");
        this.contentLength = map.containsKey("Content-Length") ? Integer.valueOf(Integer.parseInt(map.get("Content-Length"))) : null;
        this.cacheControl = map.getOrDefault("Cache-Control", "");
    }

    public void addBodyFromString(String src) {
    }

    @Override
    public String toObjectString() {
        StringBuilder sb = new StringBuilder();
        this.addResponseLine(sb);
        this.addGeneralHeader(sb);
        this.addCommonResponseHeader(sb);
        this.addResponseHeader(sb);
        this.addCommonEntityHeader(sb);
        this.addEntityHeader(sb);
        sb.append("\r\n");
        this.addMessageBody(sb);
        return sb.toString();
    }

    private void addResponseLine(StringBuilder sb) {
        sb.append(this.version).append(" ").append(this.statusCode.getCode()).append(" ").append(this.statusCode.getDescription()).append("\r\n");
    }

    private void addGeneralHeader(StringBuilder sb) {
        sb.append("CSeq").append(": ").append(this.cSeq).append("\r\n");
    }

    private void addCommonResponseHeader(StringBuilder sb) {
        if (this.session != null && !this.session.equals("")) {
            sb.append("Session").append(": ").append(this.session).append("\r\n");
        }
    }

    private void addCommonEntityHeader(StringBuilder sb) {
        if (this.contentType != null) {
            sb.append("Content-Type").append(": ").append(this.contentType.getCode()).append("\r\n");
        }
        if (this.contentBase != null && !this.contentBase.equals("")) {
            sb.append("Content-Base").append(": ").append(this.contentBase).append("\r\n");
        }
        if (this.contentLength != null && this.contentLength >= 0) {
            sb.append("Content-Length").append(": ").append(this.contentLength).append("\r\n");
        }
        if (this.cacheControl != null && !this.cacheControl.equals("")) {
            sb.append("Cache-Control").append(": ").append(this.cacheControl).append("\r\n");
        }
    }

    protected void addResponseHeader(StringBuilder sb) {
    }

    protected void addEntityHeader(StringBuilder sb) {
    }

    protected void addMessageBody(StringBuilder sb) {
    }

    public ERtspStatusCode getStatusCode() {
        return this.statusCode;
    }

    public String getWwwAuthenticate() {
        return this.wwwAuthenticate;
    }

    public ERtspContentType getContentType() {
        return this.contentType;
    }

    public String getContentBase() {
        return this.contentBase;
    }

    public Integer getContentLength() {
        return this.contentLength;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }
}

