/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtsp.model;

import com.github.xingshuangs.iot.exceptions.RtspCommException;
import com.github.xingshuangs.iot.protocol.rtsp.model.RtspMessageResponse;
import com.github.xingshuangs.iot.protocol.rtsp.model.base.RtspSessionInfo;
import com.github.xingshuangs.iot.protocol.rtsp.model.base.RtspTransport;
import java.util.Map;

public final class RtspSetupResponse
extends RtspMessageResponse {
    private RtspTransport transport;
    private RtspSessionInfo sessionInfo;

    public static RtspSetupResponse fromHeaderString(String src) {
        if (src == null || src.equals("")) {
            throw new RtspCommException("src is null or empty in RtspSetupResponse");
        }
        RtspSetupResponse response = new RtspSetupResponse();
        Map<String, String> map = response.parseHeaderAndReturnMap(src);
        if (map.containsKey("Session")) {
            response.sessionInfo = RtspSessionInfo.fromString(map.get("Session").trim());
            response.session = response.sessionInfo.getSessionId();
        }
        if (map.containsKey("Transport")) {
            response.transport = RtspTransport.fromString(map.get("Transport").trim());
        }
        return response;
    }

    public RtspTransport getTransport() {
        return this.transport;
    }

    public RtspSessionInfo getSessionInfo() {
        return this.sessionInfo;
    }
}

