/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtsp.model.sdp;

import com.github.xingshuangs.iot.exceptions.RtspCommException;

public class RtspSdpConnection {
    private String networkType;
    private String addressType;
    private String connectionAddress;

    public static RtspSdpConnection fromString(String src) {
        if (src == null || src.equals("")) {
            throw new IllegalArgumentException("The SDP, src is null or empty");
        }
        RtspSdpConnection connection = new RtspSdpConnection();
        String[] split = src.split(" ");
        if (split.length != 3) {
            throw new RtspCommException("The RtspSdpConnection data is incorrect and cannot be resolved");
        }
        connection.networkType = split[0];
        connection.addressType = split[1];
        connection.connectionAddress = split[2];
        return connection;
    }

    public String getNetworkType() {
        return this.networkType;
    }

    public String getAddressType() {
        return this.addressType;
    }

    public String getConnectionAddress() {
        return this.connectionAddress;
    }

    public void setNetworkType(String networkType) {
        this.networkType = networkType;
    }

    public void setAddressType(String addressType) {
        this.addressType = addressType;
    }

    public void setConnectionAddress(String connectionAddress) {
        this.connectionAddress = connectionAddress;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtspSdpConnection)) {
            return false;
        }
        RtspSdpConnection other = (RtspSdpConnection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$networkType = this.getNetworkType();
        String other$networkType = other.getNetworkType();
        if (this$networkType == null ? other$networkType != null : !this$networkType.equals(other$networkType)) {
            return false;
        }
        String this$addressType = this.getAddressType();
        String other$addressType = other.getAddressType();
        if (this$addressType == null ? other$addressType != null : !this$addressType.equals(other$addressType)) {
            return false;
        }
        String this$connectionAddress = this.getConnectionAddress();
        String other$connectionAddress = other.getConnectionAddress();
        return !(this$connectionAddress == null ? other$connectionAddress != null : !this$connectionAddress.equals(other$connectionAddress));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RtspSdpConnection;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $networkType = this.getNetworkType();
        result = result * 59 + ($networkType == null ? 43 : $networkType.hashCode());
        String $addressType = this.getAddressType();
        result = result * 59 + ($addressType == null ? 43 : $addressType.hashCode());
        String $connectionAddress = this.getConnectionAddress();
        result = result * 59 + ($connectionAddress == null ? 43 : $connectionAddress.hashCode());
        return result;
    }

    public String toString() {
        return "RtspSdpConnection(networkType=" + this.getNetworkType() + ", addressType=" + this.getAddressType() + ", connectionAddress=" + this.getConnectionAddress() + ")";
    }
}

