/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtsp.model.sdp;

import com.github.xingshuangs.iot.protocol.rtsp.model.sdp.RtspSdpBandwidth;
import com.github.xingshuangs.iot.protocol.rtsp.model.sdp.RtspSdpConnection;
import com.github.xingshuangs.iot.protocol.rtsp.model.sdp.RtspSdpEchoTime;
import com.github.xingshuangs.iot.protocol.rtsp.model.sdp.RtspSdpOrigin;
import com.github.xingshuangs.iot.protocol.rtsp.model.sdp.RtspSdpTime;
import com.github.xingshuangs.iot.utils.StringSpUtil;
import java.util.HashMap;
import java.util.Map;

public class RtspSdpSession {
    private Integer version;
    private RtspSdpOrigin origin;
    private String sessionName;
    private RtspSdpTime time;
    private String sessionInfo;
    private String uri;
    private String email;
    private String phone;
    private RtspSdpConnection connection;
    private RtspSdpBandwidth bandwidth;
    private RtspSdpEchoTime echoTime;
    private Map<String, String> attributes = new HashMap<String, String>();

    public static RtspSdpSession fromString(String src) {
        if (src == null || src.equals("")) {
            throw new IllegalArgumentException("session, src is null or empty");
        }
        RtspSdpSession session = new RtspSdpSession();
        Map<String, String> map = StringSpUtil.splitTwoStepByLine(src, "\r\n", "=");
        map.forEach((key, value) -> {
            switch (key) {
                case "v": {
                    session.version = Integer.parseInt(value);
                    break;
                }
                case "o": {
                    session.origin = RtspSdpOrigin.fromString(value);
                    break;
                }
                case "s": {
                    session.sessionName = value;
                    break;
                }
                case "c": {
                    session.connection = RtspSdpConnection.fromString(value);
                    break;
                }
                case "e": {
                    session.email = value;
                    break;
                }
                case "b": {
                    session.bandwidth = RtspSdpBandwidth.fromString(value);
                    break;
                }
                case "t": {
                    session.time = RtspSdpTime.fromString(value);
                    break;
                }
                case "a": {
                    int index = value.indexOf(":");
                    if (index == -1) {
                        session.attributes.put((String)value, "");
                        break;
                    }
                    session.attributes.put(value.substring(0, index), value.substring(index + 1));
                    break;
                }
            }
        });
        return session;
    }

    public Integer getVersion() {
        return this.version;
    }

    public RtspSdpOrigin getOrigin() {
        return this.origin;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public RtspSdpTime getTime() {
        return this.time;
    }

    public String getSessionInfo() {
        return this.sessionInfo;
    }

    public String getUri() {
        return this.uri;
    }

    public String getEmail() {
        return this.email;
    }

    public String getPhone() {
        return this.phone;
    }

    public RtspSdpConnection getConnection() {
        return this.connection;
    }

    public RtspSdpBandwidth getBandwidth() {
        return this.bandwidth;
    }

    public RtspSdpEchoTime getEchoTime() {
        return this.echoTime;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public void setOrigin(RtspSdpOrigin origin) {
        this.origin = origin;
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public void setTime(RtspSdpTime time) {
        this.time = time;
    }

    public void setSessionInfo(String sessionInfo) {
        this.sessionInfo = sessionInfo;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setConnection(RtspSdpConnection connection) {
        this.connection = connection;
    }

    public void setBandwidth(RtspSdpBandwidth bandwidth) {
        this.bandwidth = bandwidth;
    }

    public void setEchoTime(RtspSdpEchoTime echoTime) {
        this.echoTime = echoTime;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtspSdpSession)) {
            return false;
        }
        RtspSdpSession other = (RtspSdpSession)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        RtspSdpOrigin this$origin = this.getOrigin();
        RtspSdpOrigin other$origin = other.getOrigin();
        if (this$origin == null ? other$origin != null : !((Object)this$origin).equals(other$origin)) {
            return false;
        }
        String this$sessionName = this.getSessionName();
        String other$sessionName = other.getSessionName();
        if (this$sessionName == null ? other$sessionName != null : !this$sessionName.equals(other$sessionName)) {
            return false;
        }
        RtspSdpTime this$time = this.getTime();
        RtspSdpTime other$time = other.getTime();
        if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
            return false;
        }
        String this$sessionInfo = this.getSessionInfo();
        String other$sessionInfo = other.getSessionInfo();
        if (this$sessionInfo == null ? other$sessionInfo != null : !this$sessionInfo.equals(other$sessionInfo)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$phone = this.getPhone();
        String other$phone = other.getPhone();
        if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) {
            return false;
        }
        RtspSdpConnection this$connection = this.getConnection();
        RtspSdpConnection other$connection = other.getConnection();
        if (this$connection == null ? other$connection != null : !((Object)this$connection).equals(other$connection)) {
            return false;
        }
        RtspSdpBandwidth this$bandwidth = this.getBandwidth();
        RtspSdpBandwidth other$bandwidth = other.getBandwidth();
        if (this$bandwidth == null ? other$bandwidth != null : !((Object)this$bandwidth).equals(other$bandwidth)) {
            return false;
        }
        RtspSdpEchoTime this$echoTime = this.getEchoTime();
        RtspSdpEchoTime other$echoTime = other.getEchoTime();
        if (this$echoTime == null ? other$echoTime != null : !((Object)this$echoTime).equals(other$echoTime)) {
            return false;
        }
        Map<String, String> this$attributes = this.getAttributes();
        Map<String, String> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RtspSdpSession;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        RtspSdpOrigin $origin = this.getOrigin();
        result = result * 59 + ($origin == null ? 43 : ((Object)$origin).hashCode());
        String $sessionName = this.getSessionName();
        result = result * 59 + ($sessionName == null ? 43 : $sessionName.hashCode());
        RtspSdpTime $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        String $sessionInfo = this.getSessionInfo();
        result = result * 59 + ($sessionInfo == null ? 43 : $sessionInfo.hashCode());
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $phone = this.getPhone();
        result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
        RtspSdpConnection $connection = this.getConnection();
        result = result * 59 + ($connection == null ? 43 : ((Object)$connection).hashCode());
        RtspSdpBandwidth $bandwidth = this.getBandwidth();
        result = result * 59 + ($bandwidth == null ? 43 : ((Object)$bandwidth).hashCode());
        RtspSdpEchoTime $echoTime = this.getEchoTime();
        result = result * 59 + ($echoTime == null ? 43 : ((Object)$echoTime).hashCode());
        Map<String, String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    public String toString() {
        return "RtspSdpSession(version=" + this.getVersion() + ", origin=" + this.getOrigin() + ", sessionName=" + this.getSessionName() + ", time=" + this.getTime() + ", sessionInfo=" + this.getSessionInfo() + ", uri=" + this.getUri() + ", email=" + this.getEmail() + ", phone=" + this.getPhone() + ", connection=" + this.getConnection() + ", bandwidth=" + this.getBandwidth() + ", echoTime=" + this.getEchoTime() + ", attributes=" + this.getAttributes() + ")";
    }
}

