/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtsp.service;

import com.github.xingshuangs.iot.protocol.rtsp.authentication.DigestAuthenticator;
import com.github.xingshuangs.iot.protocol.rtsp.enums.ERtspMethod;
import com.github.xingshuangs.iot.protocol.rtsp.enums.ERtspTransportProtocol;
import com.github.xingshuangs.iot.protocol.rtsp.service.RtspNetwork;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtspClient
extends RtspNetwork {
    private static final Logger log = LoggerFactory.getLogger(RtspClient.class);
    private boolean alive;
    private ExecutorService executorService;

    public RtspClient(URI uri) {
        super(uri);
    }

    public RtspClient(URI uri, ERtspTransportProtocol transportProtocol) {
        this(uri, null, transportProtocol);
    }

    public RtspClient(URI uri, DigestAuthenticator authenticator) {
        this(uri, authenticator, ERtspTransportProtocol.TCP);
    }

    public RtspClient(URI uri, DigestAuthenticator authenticator, ERtspTransportProtocol transportProtocol) {
        super(uri, authenticator, transportProtocol);
        this.executorService = Executors.newSingleThreadExecutor();
    }

    public CompletableFuture<Void> start() {
        log.info("Open RTSP connection, address [{}], communication mode [{}]", (Object)this.uri, (Object)this.transportProtocol);
        this.connect();
        this.alive = true;
        return CompletableFuture.runAsync(() -> {
            try {
                if (!this.methods.contains((Object)ERtspMethod.GET_PARAMETER)) {
                    this.socketClientJoinForFinished();
                    return;
                }
                long lastTime = System.currentTimeMillis();
                while (this.alive) {
                    TimeUnit.MILLISECONDS.sleep(500L);
                    if (this.socketClientIsAllDone()) {
                        break;
                    }
                    if (System.currentTimeMillis() - lastTime <= (long)((this.sessionInfo.getTimeout() - 1) / 2)) continue;
                    lastTime = System.currentTimeMillis();
                    log.debug("[{}] triggers the session heartbeat and sends parameters to obtain signal", (Object)this.uri);
                    this.getParameter();
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (this.alive) {
                    this.stop();
                }
            }
        }, this.executorService);
    }

    public void stop() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        if (this.alive) {
            this.alive = false;
            this.teardown();
            this.close();
        }
    }
}

