/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtsp.service;

import com.github.xingshuangs.iot.common.IObjectByteArray;
import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.exceptions.RtspCommException;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4Header;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4MdatBox;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4MoofBox;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4SampleData;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4TrackInfo;
import com.github.xingshuangs.iot.protocol.rtp.enums.EFrameType;
import com.github.xingshuangs.iot.protocol.rtp.enums.EH264NaluType;
import com.github.xingshuangs.iot.protocol.rtp.enums.EH264SliceType;
import com.github.xingshuangs.iot.protocol.rtp.model.frame.H264VideoFrame;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.SeqParameterSet;
import com.github.xingshuangs.iot.protocol.rtsp.model.sdp.RtspTrackInfo;
import com.github.xingshuangs.iot.protocol.rtsp.service.RtspClient;
import com.github.xingshuangs.iot.utils.HexUtil;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtspFMp4Proxy {
    private static final Logger log = LoggerFactory.getLogger(RtspFMp4Proxy.class);
    private final Object objLock = new Object();
    private final RtspClient client;
    private RtspTrackInfo trackInfo;
    private long sequenceNumber = 1L;
    private final ConcurrentLinkedQueue<IObjectByteArray> buffers = new ConcurrentLinkedQueue();
    private Consumer<byte[]> fmp4DataHandle;
    private Consumer<String> codecHandle;
    private Runnable destroyHandle;
    private boolean terminal = false;
    private Mp4Header mp4Header;
    private Mp4TrackInfo mp4TrackInfo;
    private boolean asyncSend = false;
    private CompletableFuture<Void> future;
    private ExecutorService executorService;

    public Mp4Header getMp4Header() {
        return this.mp4Header;
    }

    public Mp4TrackInfo getMp4TrackInfo() {
        return this.mp4TrackInfo;
    }

    public void onFmp4DataHandle(Consumer<byte[]> fmp4DataHandle) {
        this.fmp4DataHandle = fmp4DataHandle;
    }

    public void onCodecHandle(Consumer<String> codecHandle) {
        this.codecHandle = codecHandle;
    }

    public void onDestroyHandle(Runnable destroyHandle) {
        this.destroyHandle = destroyHandle;
    }

    public RtspFMp4Proxy(RtspClient client) {
        this(client, false);
    }

    public RtspFMp4Proxy(RtspClient client, boolean asyncSend) {
        this.client = client;
        this.client.onFrameHandle(x -> {
            H264VideoFrame f = (H264VideoFrame)x;
            this.frameHandle(f);
        });
        this.client.onDestroyHandle(() -> {
            if (this.destroyHandle != null) {
                this.destroyHandle.run();
            }
        });
        this.asyncSend = asyncSend;
        if (this.asyncSend) {
            this.executorService = Executors.newSingleThreadExecutor();
            this.future = CompletableFuture.runAsync(this::executeHandle, this.executorService);
        }
    }

    private void handleSPS(H264VideoFrame frame) {
        if (this.trackInfo != null && this.trackInfo.getSps() != null) {
            return;
        }
        byte[] spsBytes = frame.getFrameSegment();
        if (spsBytes == null || spsBytes.length < 4) {
            throw new RtspCommException("SPS is not exist");
        }
        ByteReadBuff buff = new ByteReadBuff(spsBytes);
        byte[] bytes = buff.getBytes(1, 3);
        String codec = "avc1." + HexUtil.toHexString(bytes, "", false);
        SeqParameterSet sps = SeqParameterSet.createSPS(spsBytes);
        this.trackInfo = this.client.getTrackInfo();
        this.trackInfo.setSps(spsBytes);
        this.trackInfo.setCodec(codec);
        this.trackInfo.setWidth(sps.getWidth());
        this.trackInfo.setHeight(sps.getHeight());
    }

    private void handlePPS(H264VideoFrame frame) {
        if (this.trackInfo != null && this.trackInfo.getPps() != null) {
            return;
        }
        this.trackInfo = this.client.getTrackInfo();
        this.trackInfo.setPps(frame.getFrameSegment());
    }

    private void handleMp4Header() {
        if (this.mp4Header != null) {
            return;
        }
        if (this.trackInfo == null) {
            this.trackInfo = this.client.getTrackInfo();
        }
        this.mp4TrackInfo = this.toMp4TrackInfo(this.trackInfo);
        if (this.codecHandle != null) {
            this.codecHandle.accept(this.mp4TrackInfo.getCodec());
        }
        log.debug(this.mp4TrackInfo.toString());
        this.mp4Header = new Mp4Header(this.mp4TrackInfo);
        this.addFMp4Data(this.mp4Header);
    }

    private void frameHandle(H264VideoFrame frame) {
        if (frame.getFrameType() == EFrameType.AUDIO) {
            return;
        }
        if (frame.getNaluType() == EH264NaluType.SEI || frame.getNaluType() == EH264NaluType.AUD) {
            return;
        }
        if (frame.getNaluType() == EH264NaluType.SPS) {
            this.handleSPS(frame);
            return;
        }
        if (frame.getNaluType() == EH264NaluType.PPS) {
            this.handlePPS(frame);
            return;
        }
        this.handleMp4Header();
        this.doVideoFrameHandle(frame);
    }

    private void doVideoFrameHandle(H264VideoFrame videoFrame) {
        if (videoFrame.getNaluType() == EH264NaluType.IDR_SLICE && !this.mp4TrackInfo.getSampleData().isEmpty()) {
            this.addSampleData();
        } else if (this.mp4TrackInfo.getSampleData().size() >= 5 && videoFrame.getSliceType() == EH264SliceType.P) {
            this.addSampleData();
        }
        Mp4SampleData sampleData = new Mp4SampleData();
        sampleData.setData(videoFrame.getFrameSegment());
        sampleData.setDts(videoFrame.getDts());
        sampleData.getFlags().setDependedOn(videoFrame.getNaluType() == EH264NaluType.IDR_SLICE ? 2 : 1);
        sampleData.getFlags().setIsNonSync(videoFrame.getNaluType() == EH264NaluType.IDR_SLICE ? 0 : 1);
        sampleData.setDuration(videoFrame.getDuration());
        sampleData.setCts((int)(videoFrame.getPts() - videoFrame.getDts()));
        this.mp4TrackInfo.getSampleData().add(sampleData);
    }

    private void addSampleData() {
        if (this.mp4TrackInfo.getSampleData().isEmpty()) {
            return;
        }
        Mp4SampleData first = this.mp4TrackInfo.getSampleData().get(0);
        first.getFlags().setDependedOn(2);
        first.getFlags().setIsNonSync(0);
        this.addFMp4Data(new Mp4MoofBox(this.sequenceNumber, first.getDts(), this.mp4TrackInfo));
        this.addFMp4Data(new Mp4MdatBox(this.mp4TrackInfo.totalSampleData()));
        this.mp4TrackInfo = this.toMp4TrackInfo(this.trackInfo);
        ++this.sequenceNumber;
    }

    private Mp4TrackInfo toMp4TrackInfo(RtspTrackInfo track) {
        Mp4TrackInfo info = new Mp4TrackInfo();
        info.setId(track.getId());
        info.setType(track.getType());
        info.setCodec(track.getCodec());
        info.setTimescale(track.getTimescale());
        info.setDuration(track.getDuration());
        info.setWidth(track.getWidth());
        info.setHeight(track.getHeight());
        info.setSps(track.getSps());
        info.setPps(track.getPps());
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFMp4Data(IObjectByteArray iObjectByteArray) {
        if (this.asyncSend) {
            this.buffers.offer(iObjectByteArray);
            Object object = this.objLock;
            synchronized (object) {
                this.objLock.notifyAll();
            }
        } else if (this.fmp4DataHandle != null) {
            this.fmp4DataHandle.accept(iObjectByteArray.toByteArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeHandle() {
        log.debug("Start the asynchronous thread that sends FMp4 bytes of data from the proxy server");
        while (!this.terminal) {
            while (this.buffers.isEmpty() && !this.terminal) {
                Object object = this.objLock;
                synchronized (object) {
                    try {
                        this.objLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            int size = this.buffers.size();
            for (int i = 0; i < size; ++i) {
                IObjectByteArray pop = this.buffers.poll();
                if (this.fmp4DataHandle == null || pop == null) continue;
                try {
                    this.fmp4DataHandle.accept(pop.toByteArray());
                    continue;
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        log.debug("Shut down the asynchronous thread that sends FMp4 bytes of data from the proxy server");
    }

    public CompletableFuture<Void> start() {
        log.info("Open FMp4 agent server, mode [{}], address [{}]", (Object)(this.asyncSend ? "async" : "sync"), (Object)this.client.getUri());
        return this.client.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        if (this.asyncSend) {
            this.terminal = true;
            Object object = this.objLock;
            synchronized (object) {
                this.objLock.notifyAll();
            }
            if (this.future != null && !this.future.isDone()) {
                this.future.join();
            }
        }
        this.client.stop();
        log.info("Close FMp4 agent server, address [{}]", (Object)this.client.getUri());
    }
}

