/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.algorithm;

import com.github.xingshuangs.iot.protocol.s7.algorithm.S7ComGroup;
import com.github.xingshuangs.iot.protocol.s7.algorithm.S7ComItem;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class S7SequentialGroupAlg {
    private S7SequentialGroupAlg() {
    }

    public static List<S7ComGroup> writeRecombination(List<Integer> src, int targetSize, int extraSize) {
        LinkedList<S7ComGroup> groupList = new LinkedList<S7ComGroup>();
        S7ComGroup group = new S7ComGroup();
        groupList.add(group);
        int sum = 0;
        for (int i = 0; i < src.size(); ++i) {
            int number = src.get(i);
            int offset = 0;
            while (number > 0) {
                S7ComItem item = new S7ComItem(i, src.get(i), offset, 0, extraSize, 0);
                if (sum + number + item.getExtraSize() > targetSize) {
                    item.setRipeSize(targetSize - sum - item.getExtraSize());
                } else {
                    item.setRipeSize(number);
                }
                number -= item.getRipeSize();
                offset += item.getRipeSize();
                group.add(item);
                if ((sum += item.getTotalLength()) + extraSize < targetSize) continue;
                group = new S7ComGroup();
                groupList.add(group);
                sum = 0;
            }
        }
        return groupList.stream().filter(x -> !x.getItems().isEmpty()).collect(Collectors.toList());
    }

    public static List<S7ComGroup> readRecombination(List<Integer> src, int targetSize, int extraSize, int threshold) {
        LinkedList<S7ComGroup> groupList = new LinkedList<S7ComGroup>();
        S7ComGroup group = new S7ComGroup();
        groupList.add(group);
        int sum = 0;
        for (int i = 0; i < src.size(); ++i) {
            int number = src.get(i);
            int offset = 0;
            while (number > 0) {
                S7ComItem item = new S7ComItem(i, src.get(i), offset, 0, extraSize, threshold);
                if (sum + number + item.getExtraSize() > targetSize) {
                    item.setRipeSize(targetSize - sum - item.getExtraSize());
                } else {
                    item.setRipeSize(number);
                }
                number -= item.getRipeSize();
                offset += item.getRipeSize();
                group.add(item);
                if ((sum += item.getTotalLength()) + threshold < targetSize) continue;
                group = new S7ComGroup();
                groupList.add(group);
                sum = 0;
            }
        }
        return groupList.stream().filter(x -> !x.getItems().isEmpty()).collect(Collectors.toList());
    }
}

