/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.enums;

import java.util.HashMap;
import java.util.Map;

public enum EArea {
    SYSTEM_INFO_OF_200_FAMILY(3, ""),
    SYSTEM_FLAGS_OF_200_FAMILY(5, "SM"),
    ANALOG_INPUTS_OF_200_FAMILY(6, "AI"),
    ANALOG_OUTPUTS_OF_200_FAMILY(7, "AQ"),
    DIRECT_PERIPHERAL_ACCESS(-128, "PI/PQ"),
    INPUTS(-127, "I"),
    OUTPUTS(-126, "Q"),
    FLAGS(-125, "M"),
    DATA_BLOCKS(-124, "DB"),
    INSTANCE_DATA_BLOCKS(-123, "DI"),
    LOCAL_DATA(-122, "L"),
    UNKNOWN_YET(-121, "V"),
    S7_COUNTERS(28, "C"),
    S7_TIMERS(29, "T"),
    IEC_COUNTERS(30, ""),
    IEC_TIMERS(31, "");

    private final byte code;
    private final String abbr;

    public static EArea from(byte data) {
        return (EArea)((Object)Holder.INSTANCE.get(data));
    }

    private EArea(byte code, String abbr) {
        this.code = code;
        this.abbr = abbr;
    }

    public byte getCode() {
        return this.code;
    }

    public String getAbbr() {
        return this.abbr;
    }

    private static class Holder {
        private static final Map<Byte, EArea> INSTANCE = Holder.createMap();

        private Holder() {
        }

        private static Map<Byte, EArea> createMap() {
            HashMap<Byte, EArea> map = new HashMap<Byte, EArea>();
            for (EArea item : EArea.values()) {
                map.put(item.code, item);
            }
            return map;
        }
    }
}

