/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.enums;

import java.util.HashMap;
import java.util.Map;

public enum EErrorClass {
    NO_ERROR(0, "no error"),
    APPLICATION_RELATIONSHIP(-127, "application relationship"),
    OBJECT_DEFINITION(-126, "object definition"),
    NO_RESOURCES_AVAILABLE(-125, "no resources available"),
    ERROR_ON_SERVICE_PROCESSING(-124, "error on service processing"),
    ERROR_ON_SUPPLIES(-123, "error on supplies"),
    ACCESS_ERROR(-121, "access error"),
    DOWNLOAD_ERROR(-46, "download error");

    private final byte code;
    private final String description;

    public static EErrorClass from(byte data) {
        return (EErrorClass)((Object)Holder.INSTANCE.get(data));
    }

    private EErrorClass(byte code, String description) {
        this.code = code;
        this.description = description;
    }

    public byte getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    private static class Holder {
        private static final Map<Byte, EErrorClass> INSTANCE = Holder.createMap();

        private Holder() {
        }

        private static Map<Byte, EErrorClass> createMap() {
            HashMap<Byte, EErrorClass> map = new HashMap<Byte, EErrorClass>();
            for (EErrorClass item : EErrorClass.values()) {
                map.put(item.code, item);
            }
            return map;
        }
    }
}

