/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.enums;

import java.util.HashMap;
import java.util.Map;

public enum EFunctionCode {
    CPU_SERVICES(0),
    READ_VARIABLE(4),
    WRITE_VARIABLE(5),
    START_DOWNLOAD(-6),
    DOWNLOAD(-5),
    END_DOWNLOAD(-4),
    START_UPLOAD(29),
    UPLOAD(30),
    END_UPLOAD(31),
    PLC_CONTROL(40),
    PLC_STOP(41),
    SETUP_COMMUNICATION(-16);

    private final byte code;

    public static EFunctionCode from(byte data) {
        return (EFunctionCode)((Object)Holder.INSTANCE.get(data));
    }

    private EFunctionCode(byte code) {
        this.code = code;
    }

    public byte getCode() {
        return this.code;
    }

    private static class Holder {
        private static final Map<Byte, EFunctionCode> INSTANCE = Holder.createMap();

        private Holder() {
        }

        private static Map<Byte, EFunctionCode> createMap() {
            HashMap<Byte, EFunctionCode> map = new HashMap<Byte, EFunctionCode>();
            for (EFunctionCode item : EFunctionCode.values()) {
                map.put(item.code, item);
            }
            return map;
        }
    }
}

