/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.enums;

import java.util.HashMap;
import java.util.Map;

public enum ENckModule {
    Y(16, "Global system data"),
    YNCFL(17, "NCK instruction groups"),
    FU(18, "NCU global settable frames"),
    FA(19, "Active NCU global frames"),
    TO(20, "Tool data"),
    RP(21, "Arithmetic parameters"),
    SE(22, "Setting data"),
    SGUD(23, "SGUD( (byte) ,Block"),
    LUD(24, "Local userdata"),
    TC(25, "Toolholder parameters"),
    M(26, "Machine data"),
    WAL(28, "Working area limitation"),
    DIAG(30, "Internal diagnostic data"),
    CC(31, "Unknown"),
    FE(32, "Channel( (byte) ,specific external frame"),
    TD(33, "Tool data: General data"),
    TS(34, "Tool edge data: Monitoring data"),
    TG(35, "Tool data: Grinding( (byte) ,specific data"),
    TU(36, "Tool data"),
    TUE(37, "Tool edge data, userdefined data"),
    TV(38, "Tool data, directory"),
    TM(39, "Magazine data: General data"),
    TP(40, "Magazine data: Location data"),
    TPM(41, "Magazine data: Multiple assignment of location data"),
    TT(42, "Magazine data: Location typ"),
    TMV(43, "Magazine data: Directory"),
    TMC(44, "Magazine data: Configuration data"),
    MGUD(45, "MGUD( (byte) ,Block"),
    UGUD(46, "UGUD( (byte) ,Block"),
    GUD4(47, "GUD4( (byte) ,Block"),
    GUD5(48, "GUD5( (byte) ,Block"),
    GUD6(49, "GUD6( (byte) ,Block"),
    GUD7(50, "GUD7( (byte) ,Block"),
    GUD8(51, "GUD8( (byte) ,Block"),
    GUD9(52, "GUD9( (byte) ,Block"),
    PA(53, "Channel( (byte) ,specific protection zones"),
    GD1(54, "SGUD( (byte) ,Block GD1"),
    NIB(55, "State data: Nibbling"),
    ETP(56, "Types of events"),
    ETPD(57, "Data lists for protocolling"),
    SYNACT(58, "Channel( (byte) ,specific synchronous actions"),
    DIAGN(59, "Diagnostic data"),
    VSYN(60, "Channel( (byte) ,specific user variables for synchronous actions"),
    TUS(61, "Tool data: user monitoring data"),
    TUM(62, "Tool data: user magazine data"),
    TUP(63, "Tool data: user magazine place data"),
    TF(64, "Parameterizing, return parameters of _N_TMGETT, _N_TSEARC"),
    FB(65, "Channel( (byte) ,specific base frames"),
    SSP2(66, "State data: Spindle"),
    PUD(67, "programmglobale Benutzerdaten"),
    TOS(68, "Edge( (byte) ,related location( (byte) ,dependent fine total offsets"),
    TOST(69, "Edge( (byte) ,related location( (byte) ,dependent fine total offsets, transformed"),
    TOE(70, "Edge( (byte) ,related coarse total offsets, setup offsets"),
    TOET(71, "Edge( (byte) ,related coarse total offsets, transformed setup offsets"),
    AD(72, "Adapter data"),
    TOT(73, "Edge data: Transformed offset data"),
    AEV(74, "Working offsets: Directory"),
    YFAFL(75, "NCK instruction groups (Fanuc)"),
    FS(76, "System( (byte) ,Frame"),
    SD(77, "Servo data"),
    TAD(78, "Application( (byte) ,specific data"),
    TAO(79, "Application( (byte) ,specific cutting edge data"),
    TAS(80, "Application( (byte) ,specific monitoring data"),
    TAM(81, "Application( (byte) ,specific magazine data"),
    TAP(82, "Application( (byte) ,specific magazine location data"),
    MEM(83, "Unknown"),
    SALUC(84, "Alarm actions: List in reverse chronological order"),
    AUXFU(85, "Auxiliary functions"),
    TDC(86, "Tool/Tools"),
    CP(87, "Generic coupling"),
    SDME(110, "Unknown"),
    SPARPI(111, "Program pointer on interruption"),
    SEGA(112, "State data: Geometry axes in tool offset memory (extended)"),
    SEMA(113, "State data: Machine axes (extended)"),
    SSP(114, "State data: Spindle"),
    SGA(115, "State data: Geometry axes in tool offset memory"),
    SMA(116, "State data: Machine axes"),
    SALAL(117, "Alarms: List organized according to time"),
    SALAP(118, "Alarms: List organized according to priority"),
    SALA(119, "Alarms: List organized according to time"),
    SSYNAC(120, "Synchronous actions"),
    SPARPF(121, "Program pointers for block search and stop run"),
    SPARPP(122, "Program pointer in automatic operation"),
    SNCF(123, "Active G functions"),
    SPARP(125, "Part program information"),
    SINF(126, "Part( (byte) ,program( (byte) ,specific status data"),
    S(127, "State data"),
    UNKNOWN1(-128, "State data"),
    UNKNOWN2(-127, "State data"),
    UNKNOWN3(-126, "State data"),
    UNKNOWN4(-125, "State data"),
    UNKNOWN5(-124, "State data"),
    UNKNOWN6(-123, "State data");

    private final byte code;
    private final String description;

    public static ENckModule from(byte data) {
        return (ENckModule)((Object)Holder.INSTANCE.get(data));
    }

    private ENckModule(byte code, String description) {
        this.code = code;
        this.description = description;
    }

    public byte getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    private static class Holder {
        private static final Map<Byte, ENckModule> INSTANCE = Holder.createMap();

        private Holder() {
        }

        private static Map<Byte, ENckModule> createMap() {
            HashMap<Byte, ENckModule> map = new HashMap<Byte, ENckModule>();
            for (ENckModule item : ENckModule.values()) {
                map.put(item.code, item);
            }
            return map;
        }
    }
}

