/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.enums;

import java.util.HashMap;
import java.util.Map;

public enum EReturnCode {
    RESERVED(0, "reserved"),
    HARDWARE_ERROR(1, "hardware error"),
    ACCESSING_THE_OBJECT_NOT_ALLOWED(3, "accessing the object not allowed"),
    INVALID_ADDRESS(5, "invalid address"),
    DATA_TYPE_NOT_SUPPORTED(6, "data type not supported"),
    DATA_TYPE_INCONSISTENT(7, "data type inconsistent"),
    OBJECT_DOES_NOT_EXIST(10, "object does not exist"),
    SUCCESS(-1, "success");

    private final byte code;
    private final String description;

    public static EReturnCode from(byte data) {
        return (EReturnCode)((Object)Holder.INSTANCE.get(data));
    }

    private EReturnCode(byte code, String description) {
        this.code = code;
        this.description = description;
    }

    public byte getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    private static class Holder {
        private static final Map<Byte, EReturnCode> INSTANCE = Holder.createMap();

        private Holder() {
        }

        private static Map<Byte, EReturnCode> createMap() {
            HashMap<Byte, EReturnCode> map = new HashMap<Byte, EReturnCode>();
            for (EReturnCode item : EReturnCode.values()) {
                map.put(item.code, item);
            }
            return map;
        }
    }
}

