/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.model;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.protocol.s7.enums.EFunctionCode;
import com.github.xingshuangs.iot.protocol.s7.model.UploadParameter;
import com.github.xingshuangs.iot.utils.BooleanUtil;

public class EndUploadParameter
extends UploadParameter {
    public EndUploadParameter() {
        this.functionCode = EFunctionCode.END_UPLOAD;
    }

    public static EndUploadParameter createDefault(long uploadId) {
        EndUploadParameter parameter = new EndUploadParameter();
        parameter.id = uploadId;
        return parameter;
    }

    public static EndUploadParameter fromBytes(byte[] data) {
        return EndUploadParameter.fromBytes(data, 0);
    }

    public static EndUploadParameter fromBytes(byte[] data, int offset) {
        if (data.length < 8) {
            throw new IndexOutOfBoundsException("UploadParameter, data length < 8");
        }
        ByteReadBuff buff = new ByteReadBuff(data, offset);
        EndUploadParameter res = new EndUploadParameter();
        res.functionCode = EFunctionCode.from(buff.getByte());
        byte b = buff.getByte();
        res.moreDataFollowing = BooleanUtil.getValue(b, 0);
        res.errorStatus = BooleanUtil.getValue(b, 1);
        res.errorCode = buff.getBytes(2);
        res.id = buff.getUInt32();
        return res;
    }
}

