/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.model;

import com.github.xingshuangs.iot.exceptions.S7CommException;
import com.github.xingshuangs.iot.protocol.s7.enums.EFunctionCode;
import com.github.xingshuangs.iot.protocol.s7.enums.EMessageType;
import com.github.xingshuangs.iot.protocol.s7.model.DownloadParameter;
import com.github.xingshuangs.iot.protocol.s7.model.EndDownloadParameter;
import com.github.xingshuangs.iot.protocol.s7.model.EndUploadParameter;
import com.github.xingshuangs.iot.protocol.s7.model.Parameter;
import com.github.xingshuangs.iot.protocol.s7.model.PlcControlAckParameter;
import com.github.xingshuangs.iot.protocol.s7.model.PlcControlParameter;
import com.github.xingshuangs.iot.protocol.s7.model.PlcStopParameter;
import com.github.xingshuangs.iot.protocol.s7.model.ReadWriteParameter;
import com.github.xingshuangs.iot.protocol.s7.model.SetupComParameter;
import com.github.xingshuangs.iot.protocol.s7.model.StartDownloadParameter;
import com.github.xingshuangs.iot.protocol.s7.model.StartUploadAckParameter;
import com.github.xingshuangs.iot.protocol.s7.model.StartUploadParameter;
import com.github.xingshuangs.iot.protocol.s7.model.UploadAckParameter;
import com.github.xingshuangs.iot.protocol.s7.model.UploadParameter;

public class ParameterBuilder {
    private ParameterBuilder() {
    }

    public static Parameter fromBytes(byte[] data, EMessageType messageType) {
        EFunctionCode functionCode = EFunctionCode.from(data[0]);
        switch (functionCode) {
            case CPU_SERVICES: {
                return null;
            }
            case READ_VARIABLE: 
            case WRITE_VARIABLE: {
                return ReadWriteParameter.fromBytes(data);
            }
            case START_DOWNLOAD: {
                return messageType == EMessageType.ACK_DATA ? new Parameter(EFunctionCode.START_DOWNLOAD) : StartDownloadParameter.fromBytes(data);
            }
            case DOWNLOAD: {
                return messageType == EMessageType.ACK_DATA ? new Parameter(EFunctionCode.DOWNLOAD) : DownloadParameter.fromBytes(data);
            }
            case END_DOWNLOAD: {
                return messageType == EMessageType.ACK_DATA ? new Parameter(EFunctionCode.END_DOWNLOAD) : EndDownloadParameter.fromBytes(data);
            }
            case START_UPLOAD: {
                return messageType == EMessageType.ACK_DATA ? StartUploadAckParameter.fromBytes(data) : StartUploadParameter.fromBytes(data);
            }
            case UPLOAD: {
                return messageType == EMessageType.ACK_DATA ? UploadAckParameter.fromBytes(data) : UploadParameter.fromBytes(data);
            }
            case END_UPLOAD: {
                return messageType == EMessageType.ACK_DATA ? new Parameter(EFunctionCode.END_UPLOAD) : EndUploadParameter.fromBytes(data);
            }
            case PLC_CONTROL: {
                if (messageType == EMessageType.ACK) {
                    return PlcControlAckParameter.fromBytes(data);
                }
                return messageType == EMessageType.ACK_DATA ? new Parameter(EFunctionCode.PLC_CONTROL) : PlcControlParameter.fromBytes(data);
            }
            case PLC_STOP: {
                return messageType == EMessageType.ACK_DATA ? new Parameter(EFunctionCode.PLC_STOP) : PlcStopParameter.fromBytes(data);
            }
            case SETUP_COMMUNICATION: {
                return SetupComParameter.fromBytes(data);
            }
        }
        throw new S7CommException("function code of Parameter is not exist");
    }
}

