/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.model;

import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.s7.model.PlcControlParamBlock;
import java.util.ArrayList;
import java.util.List;

public class PlcControlInsertParamBlock
extends PlcControlParamBlock {
    private byte unknowByte = 0;
    private List<String> fileNames = new ArrayList<String>();

    public void addFileName(String filename) {
        this.fileNames.add(filename);
    }

    @Override
    public int byteArrayLength() {
        int sum = 2;
        for (String item : this.fileNames) {
            sum += item.length();
        }
        return sum;
    }

    @Override
    public byte[] toByteArray() {
        ByteWriteBuff buff = ByteWriteBuff.newInstance(this.byteArrayLength()).putByte(this.fileNames.size()).putByte(this.unknowByte);
        for (String item : this.fileNames) {
            buff.putString(item);
        }
        return buff.getData();
    }

    public byte getUnknowByte() {
        return this.unknowByte;
    }

    public List<String> getFileNames() {
        return this.fileNames;
    }

    public void setUnknowByte(byte unknowByte) {
        this.unknowByte = unknowByte;
    }

    public void setFileNames(List<String> fileNames) {
        this.fileNames = fileNames;
    }

    public String toString() {
        return "PlcControlInsertParamBlock(unknowByte=" + this.getUnknowByte() + ", fileNames=" + this.getFileNames() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlcControlInsertParamBlock)) {
            return false;
        }
        PlcControlInsertParamBlock other = (PlcControlInsertParamBlock)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getUnknowByte() != other.getUnknowByte()) {
            return false;
        }
        List<String> this$fileNames = this.getFileNames();
        List<String> other$fileNames = other.getFileNames();
        return !(this$fileNames == null ? other$fileNames != null : !((Object)this$fileNames).equals(other$fileNames));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlcControlInsertParamBlock;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getUnknowByte();
        List<String> $fileNames = this.getFileNames();
        result = result * 59 + ($fileNames == null ? 43 : ((Object)$fileNames).hashCode());
        return result;
    }
}

