/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.model;

import com.github.xingshuangs.iot.common.IObjectByteArray;
import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.exceptions.S7CommException;
import com.github.xingshuangs.iot.protocol.s7.enums.EFunctionCode;
import com.github.xingshuangs.iot.protocol.s7.enums.ESyntaxID;
import com.github.xingshuangs.iot.protocol.s7.model.Parameter;
import com.github.xingshuangs.iot.protocol.s7.model.RequestBaseItem;
import com.github.xingshuangs.iot.protocol.s7.model.RequestItem;
import com.github.xingshuangs.iot.protocol.s7.model.RequestNckItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ReadWriteParameter
extends Parameter
implements IObjectByteArray {
    private int itemCount = 0;
    private List<RequestBaseItem> requestItems = new ArrayList<RequestBaseItem>();

    public void addItem(RequestBaseItem item) {
        this.requestItems.add(item);
        this.itemCount = this.requestItems.size();
    }

    public void addItem(Collection<? extends RequestBaseItem> items) {
        this.requestItems.addAll(items);
        this.itemCount = this.requestItems.size();
    }

    @Override
    public int byteArrayLength() {
        return 2 + this.requestItems.stream().mapToInt(RequestBaseItem::byteArrayLength).sum();
    }

    @Override
    public byte[] toByteArray() {
        int length = 2 + this.requestItems.stream().mapToInt(RequestBaseItem::byteArrayLength).sum();
        ByteWriteBuff buff = ByteWriteBuff.newInstance(length).putByte(this.functionCode.getCode()).putByte(this.itemCount);
        for (RequestBaseItem requestItem : this.requestItems) {
            buff.putBytes(requestItem.toByteArray());
        }
        return buff.getData();
    }

    public static ReadWriteParameter fromBytes(byte[] data) {
        if (data.length < 2) {
            throw new S7CommException("Parameter parsing error, parameter byte array length < 2");
        }
        ByteReadBuff buff = new ByteReadBuff(data);
        ReadWriteParameter readWriteParameter = new ReadWriteParameter();
        readWriteParameter.functionCode = EFunctionCode.from(buff.getByte());
        readWriteParameter.itemCount = buff.getByteToInt();
        if (readWriteParameter.itemCount == 0) {
            return readWriteParameter;
        }
        if (data.length == 2) {
            return readWriteParameter;
        }
        int off = 2;
        for (int i = 0; i < readWriteParameter.itemCount; ++i) {
            RequestBaseItem item = ReadWriteParameter.parserItem(data, off);
            readWriteParameter.requestItems.add(item);
            off += item.byteArrayLength();
        }
        return readWriteParameter;
    }

    public static RequestBaseItem parserItem(byte[] data, int offset) {
        ByteReadBuff buff = new ByteReadBuff(data, offset);
        byte aByte = buff.getByte(2 + offset);
        ESyntaxID syntaxID = ESyntaxID.from(aByte);
        switch (syntaxID) {
            case S7ANY: {
                return RequestItem.fromBytes(data, offset);
            }
            case NCK: {
                return RequestNckItem.fromBytes(data, offset);
            }
        }
        throw new S7CommException("Unable to resolve the corresponding type of RequestBaseItem");
    }

    public static ReadWriteParameter createReqParameter(EFunctionCode functionCode, Collection<? extends RequestBaseItem> requestItems) {
        ReadWriteParameter parameter = new ReadWriteParameter();
        parameter.functionCode = functionCode;
        parameter.addItem(requestItems);
        return parameter;
    }

    public static ReadWriteParameter createAckParameter(ReadWriteParameter request) {
        ReadWriteParameter parameter = new ReadWriteParameter();
        parameter.functionCode = request.functionCode;
        parameter.itemCount = request.itemCount;
        return parameter;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReadWriteParameter)) {
            return false;
        }
        ReadWriteParameter other = (ReadWriteParameter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getItemCount() != other.getItemCount()) {
            return false;
        }
        List<RequestBaseItem> this$requestItems = this.getRequestItems();
        List<RequestBaseItem> other$requestItems = other.getRequestItems();
        return !(this$requestItems == null ? other$requestItems != null : !((Object)this$requestItems).equals(other$requestItems));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ReadWriteParameter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getItemCount();
        List<RequestBaseItem> $requestItems = this.getRequestItems();
        result = result * 59 + ($requestItems == null ? 43 : ((Object)$requestItems).hashCode());
        return result;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public List<RequestBaseItem> getRequestItems() {
        return this.requestItems;
    }

    public void setItemCount(int itemCount) {
        this.itemCount = itemCount;
    }

    public void setRequestItems(List<RequestBaseItem> requestItems) {
        this.requestItems = requestItems;
    }

    @Override
    public String toString() {
        return "ReadWriteParameter(itemCount=" + this.getItemCount() + ", requestItems=" + this.getRequestItems() + ")";
    }
}

