/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.model;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.s7.enums.EArea;
import com.github.xingshuangs.iot.protocol.s7.enums.EParamVariableType;
import com.github.xingshuangs.iot.protocol.s7.enums.ESyntaxID;
import com.github.xingshuangs.iot.protocol.s7.model.RequestBaseItem;
import com.github.xingshuangs.iot.utils.IntegerUtil;

public class RequestItem
extends RequestBaseItem {
    public static final int BYTE_LENGTH = 12;
    private EParamVariableType variableType = EParamVariableType.BYTE;
    private int count = 0;
    private int dbNumber = 0;
    private EArea area = EArea.INPUTS;
    private int byteAddress = 0;
    private int bitAddress = 0;

    public RequestItem() {
        this.specificationType = (byte)18;
        this.lengthOfFollowing = 10;
        this.syntaxId = ESyntaxID.S7ANY;
    }

    public int getByteCount() {
        int multiplier = EArea.S7_TIMERS == this.area || EArea.S7_COUNTERS == this.area ? 2 : 1;
        return this.count * multiplier;
    }

    @Override
    public int byteArrayLength() {
        return 12;
    }

    @Override
    public byte[] toByteArray() {
        ByteWriteBuff buff = ByteWriteBuff.newInstance(12).putByte(this.specificationType).putByte(this.lengthOfFollowing).putByte(this.syntaxId.getCode()).putByte(this.variableType.getCode()).putShort(this.count).putShort(this.dbNumber).putByte(this.area.getCode());
        if (this.area == EArea.S7_COUNTERS || this.area == EArea.S7_TIMERS) {
            buff.putBytes(IntegerUtil.toByteArray(this.byteAddress << 2), 1);
        } else {
            buff.putBytes(IntegerUtil.toByteArray((this.byteAddress << 3) + this.bitAddress), 1);
        }
        return buff.getData();
    }

    @Override
    public String address() {
        String areaStr = this.area == EArea.DATA_BLOCKS ? String.format("%s%d.%d", this.area.getAbbr(), this.dbNumber, this.byteAddress) : String.format("%s%d", this.area.getAbbr(), this.byteAddress);
        return String.format("%s.%d", areaStr, this.bitAddress);
    }

    public RequestItem copy() {
        RequestItem requestItem = new RequestItem();
        requestItem.specificationType = this.specificationType;
        requestItem.lengthOfFollowing = this.lengthOfFollowing;
        requestItem.syntaxId = this.syntaxId;
        requestItem.variableType = this.variableType;
        requestItem.count = this.count;
        requestItem.dbNumber = this.dbNumber;
        requestItem.area = this.area;
        requestItem.byteAddress = this.byteAddress;
        requestItem.bitAddress = this.bitAddress;
        return requestItem;
    }

    public static RequestItem fromBytes(byte[] data) {
        return RequestItem.fromBytes(data, 0);
    }

    public static RequestItem fromBytes(byte[] data, int offset) {
        ByteReadBuff buff = new ByteReadBuff(data, offset);
        RequestItem requestItem = new RequestItem();
        requestItem.specificationType = buff.getByte();
        requestItem.lengthOfFollowing = buff.getByteToInt();
        requestItem.syntaxId = ESyntaxID.from(buff.getByte());
        requestItem.variableType = EParamVariableType.from(buff.getByte());
        requestItem.count = buff.getUInt16();
        requestItem.dbNumber = buff.getUInt16();
        requestItem.area = EArea.from(buff.getByte());
        if (requestItem.area == EArea.S7_TIMERS || requestItem.area == EArea.S7_COUNTERS) {
            requestItem.byteAddress = IntegerUtil.toInt32In3Bytes(data, 9 + offset) >> 2;
            requestItem.bitAddress = 0;
        } else {
            requestItem.byteAddress = IntegerUtil.toInt32In3Bytes(data, 9 + offset) >> 3;
            requestItem.bitAddress = buff.getByte(11 + offset) & 7;
        }
        return requestItem;
    }

    public static RequestItem createByParams(EParamVariableType variableType, int count, EArea area, int dbNumber, int byteAddress, int bitAddress) {
        RequestItem requestItem = new RequestItem();
        requestItem.setVariableType(variableType);
        requestItem.setArea(area);
        requestItem.setCount(count);
        requestItem.setDbNumber(dbNumber);
        requestItem.setByteAddress(byteAddress);
        requestItem.setBitAddress(bitAddress);
        return requestItem;
    }

    public EParamVariableType getVariableType() {
        return this.variableType;
    }

    public int getCount() {
        return this.count;
    }

    public int getDbNumber() {
        return this.dbNumber;
    }

    public EArea getArea() {
        return this.area;
    }

    public int getByteAddress() {
        return this.byteAddress;
    }

    public int getBitAddress() {
        return this.bitAddress;
    }

    public void setVariableType(EParamVariableType variableType) {
        this.variableType = variableType;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setDbNumber(int dbNumber) {
        this.dbNumber = dbNumber;
    }

    public void setArea(EArea area) {
        this.area = area;
    }

    public void setByteAddress(int byteAddress) {
        this.byteAddress = byteAddress;
    }

    public void setBitAddress(int bitAddress) {
        this.bitAddress = bitAddress;
    }

    @Override
    public String toString() {
        return "RequestItem(variableType=" + (Object)((Object)this.getVariableType()) + ", count=" + this.getCount() + ", dbNumber=" + this.getDbNumber() + ", area=" + (Object)((Object)this.getArea()) + ", byteAddress=" + this.getByteAddress() + ", bitAddress=" + this.getBitAddress() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestItem)) {
            return false;
        }
        RequestItem other = (RequestItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        if (this.getDbNumber() != other.getDbNumber()) {
            return false;
        }
        if (this.getByteAddress() != other.getByteAddress()) {
            return false;
        }
        if (this.getBitAddress() != other.getBitAddress()) {
            return false;
        }
        EParamVariableType this$variableType = this.getVariableType();
        EParamVariableType other$variableType = other.getVariableType();
        if (this$variableType == null ? other$variableType != null : !((Object)((Object)this$variableType)).equals((Object)other$variableType)) {
            return false;
        }
        EArea this$area = this.getArea();
        EArea other$area = other.getArea();
        return !(this$area == null ? other$area != null : !((Object)((Object)this$area)).equals((Object)other$area));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RequestItem;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getCount();
        result = result * 59 + this.getDbNumber();
        result = result * 59 + this.getByteAddress();
        result = result * 59 + this.getBitAddress();
        EParamVariableType $variableType = this.getVariableType();
        result = result * 59 + ($variableType == null ? 43 : ((Object)((Object)$variableType)).hashCode());
        EArea $area = this.getArea();
        result = result * 59 + ($area == null ? 43 : ((Object)((Object)$area)).hashCode());
        return result;
    }
}

