/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.model;

import com.github.xingshuangs.iot.common.IObjectByteArray;
import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.s7.enums.EDestinationFileSystem;
import com.github.xingshuangs.iot.protocol.s7.enums.EFileBlockType;
import com.github.xingshuangs.iot.protocol.s7.enums.EFunctionCode;
import com.github.xingshuangs.iot.protocol.s7.model.DownloadParameter;
import com.github.xingshuangs.iot.utils.BooleanUtil;

public class StartDownloadParameter
extends DownloadParameter
implements IObjectByteArray {
    private int part2Length = 13;
    private String unknownChar = "1";
    private int loadMemoryLength = 0;
    private int mC7CodeLength = 0;

    public StartDownloadParameter() {
        this.functionCode = EFunctionCode.START_DOWNLOAD;
    }

    @Override
    public int byteArrayLength() {
        return 32;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(32).putByte(this.functionCode.getCode()).putByte((byte)(BooleanUtil.setBit(0, this.moreDataFollowing) | BooleanUtil.setBit(1, this.errorStatus))).putBytes(this.errorCode).putInteger(this.id).putByte(this.fileNameLength).putString(this.fileIdentifier).putBytes(this.blockType.getByteArray()).putString(String.format("%05d", this.blockNumber)).putByte(this.destinationFileSystem.getCode()).putByte(this.part2Length).putString(this.unknownChar).putString(String.format("%06d", this.loadMemoryLength)).putString(String.format("%06d", this.mC7CodeLength)).getData();
    }

    public static StartDownloadParameter fromBytes(byte[] data) {
        return StartDownloadParameter.fromBytes(data, 0);
    }

    public static StartDownloadParameter fromBytes(byte[] data, int offset) {
        if (data.length < 32) {
            throw new IndexOutOfBoundsException("StartDownloadParameter, data length < 32");
        }
        StartDownloadParameter res = new StartDownloadParameter();
        ByteReadBuff buff = new ByteReadBuff(data, offset);
        res.functionCode = EFunctionCode.from(buff.getByte());
        byte b = buff.getByte();
        res.moreDataFollowing = BooleanUtil.getValue(b, 0);
        res.errorStatus = BooleanUtil.getValue(b, 1);
        res.errorCode = buff.getBytes(2);
        res.id = buff.getUInt32();
        res.fileNameLength = buff.getByteToInt();
        res.fileIdentifier = buff.getString(1);
        res.blockType = EFileBlockType.from(buff.getString(2));
        res.blockNumber = Integer.parseInt(buff.getString(5));
        res.destinationFileSystem = EDestinationFileSystem.from(buff.getByte());
        res.part2Length = buff.getByteToInt();
        res.unknownChar = buff.getString(1);
        res.loadMemoryLength = Integer.parseInt(buff.getString(6));
        res.mC7CodeLength = Integer.parseInt(buff.getString(6));
        return res;
    }

    public static StartDownloadParameter createDefault(EFileBlockType blockType, int blockNumber, EDestinationFileSystem destinationFileSystem, int loadMemoryLength, int mC7CodeLength) {
        StartDownloadParameter parameter = new StartDownloadParameter();
        parameter.blockType = blockType;
        parameter.blockNumber = blockNumber;
        parameter.destinationFileSystem = destinationFileSystem;
        parameter.loadMemoryLength = loadMemoryLength;
        parameter.mC7CodeLength = mC7CodeLength;
        return parameter;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StartDownloadParameter)) {
            return false;
        }
        StartDownloadParameter other = (StartDownloadParameter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getPart2Length() != other.getPart2Length()) {
            return false;
        }
        if (this.getLoadMemoryLength() != other.getLoadMemoryLength()) {
            return false;
        }
        if (this.getMC7CodeLength() != other.getMC7CodeLength()) {
            return false;
        }
        String this$unknownChar = this.getUnknownChar();
        String other$unknownChar = other.getUnknownChar();
        return !(this$unknownChar == null ? other$unknownChar != null : !this$unknownChar.equals(other$unknownChar));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof StartDownloadParameter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getPart2Length();
        result = result * 59 + this.getLoadMemoryLength();
        result = result * 59 + this.getMC7CodeLength();
        String $unknownChar = this.getUnknownChar();
        result = result * 59 + ($unknownChar == null ? 43 : $unknownChar.hashCode());
        return result;
    }

    public int getPart2Length() {
        return this.part2Length;
    }

    public String getUnknownChar() {
        return this.unknownChar;
    }

    public int getLoadMemoryLength() {
        return this.loadMemoryLength;
    }

    public int getMC7CodeLength() {
        return this.mC7CodeLength;
    }

    public void setPart2Length(int part2Length) {
        this.part2Length = part2Length;
    }

    public void setUnknownChar(String unknownChar) {
        this.unknownChar = unknownChar;
    }

    public void setLoadMemoryLength(int loadMemoryLength) {
        this.loadMemoryLength = loadMemoryLength;
    }

    public void setMC7CodeLength(int mC7CodeLength) {
        this.mC7CodeLength = mC7CodeLength;
    }

    @Override
    public String toString() {
        return "StartDownloadParameter(part2Length=" + this.getPart2Length() + ", unknownChar=" + this.getUnknownChar() + ", loadMemoryLength=" + this.getLoadMemoryLength() + ", mC7CodeLength=" + this.getMC7CodeLength() + ")";
    }
}

