/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.model;

import com.github.xingshuangs.iot.common.IObjectByteArray;
import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;

public class TPKT
implements IObjectByteArray {
    public static final int BYTE_LENGTH = 4;
    private byte version = (byte)3;
    private byte reserved = 0;
    private int length = 0;

    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public int byteArrayLength() {
        return 4;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(4).putByte(this.version).putByte(this.reserved).putShort(this.length).getData();
    }

    public static TPKT fromBytes(byte[] data) {
        if (data.length < 4) {
            throw new IndexOutOfBoundsException(String.format("During TPKT conversion, the length of byte data is less than %d", 4));
        }
        ByteReadBuff buff = new ByteReadBuff(data);
        TPKT tpkt = new TPKT();
        tpkt.version = buff.getByte();
        tpkt.reserved = buff.getByte();
        tpkt.length = buff.getUInt16();
        return tpkt;
    }

    public byte getVersion() {
        return this.version;
    }

    public byte getReserved() {
        return this.reserved;
    }

    public int getLength() {
        return this.length;
    }
}

