/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.model;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.exceptions.S7CommException;
import com.github.xingshuangs.iot.protocol.s7.enums.EMessageType;
import com.github.xingshuangs.iot.protocol.s7.model.Datum;
import java.util.Arrays;

public class UpDownloadDatum
extends Datum {
    private int length = 0;
    private int unknownBytes = 0;
    private byte[] data = new byte[0];

    @Override
    public int byteArrayLength() {
        return 4 + this.data.length;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(4 + this.data.length).putShort(this.length).putShort(this.unknownBytes).putBytes(this.data).getData();
    }

    public static UpDownloadDatum fromBytes(byte[] data, EMessageType messageType) {
        return UpDownloadDatum.fromBytes(data, 0, messageType);
    }

    public static UpDownloadDatum fromBytes(byte[] data, int offset, EMessageType messageType) {
        if (EMessageType.ACK_DATA != messageType) {
            throw new S7CommException("Not response data");
        }
        UpDownloadDatum res = new UpDownloadDatum();
        ByteReadBuff buff = new ByteReadBuff(data, offset);
        res.length = buff.getUInt16();
        res.unknownBytes = buff.getUInt16();
        res.data = buff.getBytes(res.length);
        return res;
    }

    public static UpDownloadDatum createDownloadData(byte[] data) {
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("data");
        }
        UpDownloadDatum res = new UpDownloadDatum();
        res.length = data.length;
        res.unknownBytes = 251;
        res.data = data;
        return res;
    }

    public int getLength() {
        return this.length;
    }

    public int getUnknownBytes() {
        return this.unknownBytes;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setUnknownBytes(int unknownBytes) {
        this.unknownBytes = unknownBytes;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    @Override
    public String toString() {
        return "UpDownloadDatum(length=" + this.getLength() + ", unknownBytes=" + this.getUnknownBytes() + ", data=" + Arrays.toString(this.getData()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpDownloadDatum)) {
            return false;
        }
        UpDownloadDatum other = (UpDownloadDatum)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        if (this.getUnknownBytes() != other.getUnknownBytes()) {
            return false;
        }
        return Arrays.equals(this.getData(), other.getData());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UpDownloadDatum;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getLength();
        result = result * 59 + this.getUnknownBytes();
        result = result * 59 + Arrays.hashCode(this.getData());
        return result;
    }
}

