/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.service;

import com.github.xingshuangs.iot.protocol.s7.model.DataItem;
import com.github.xingshuangs.iot.protocol.s7.model.RequestItem;
import com.github.xingshuangs.iot.protocol.s7.utils.AddressUtil;
import com.github.xingshuangs.iot.utils.ByteUtil;
import com.github.xingshuangs.iot.utils.FloatUtil;
import com.github.xingshuangs.iot.utils.IntegerUtil;
import com.github.xingshuangs.iot.utils.LongUtil;
import com.github.xingshuangs.iot.utils.ShortUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class MultiAddressWrite {
    List<RequestItem> requestItems = new ArrayList<RequestItem>();
    List<DataItem> dataItems = new ArrayList<DataItem>();

    public MultiAddressWrite addBoolean(String address, boolean data) {
        this.requestItems.add(AddressUtil.parseBit(address));
        this.dataItems.add(DataItem.createReqByBoolean(data));
        return this;
    }

    public MultiAddressWrite addByte(String address, byte data) {
        this.requestItems.add(AddressUtil.parseByte(address, 1));
        this.dataItems.add(DataItem.createReqByByte(data));
        return this;
    }

    public MultiAddressWrite addByte(String address, byte[] data) {
        this.requestItems.add(AddressUtil.parseByte(address, data.length));
        this.dataItems.add(DataItem.createReqByByte(data));
        return this;
    }

    public MultiAddressWrite addUInt16(String address, int data) {
        byte[] bytes = ShortUtil.toByteArray(data);
        this.addByte(address, bytes);
        return this;
    }

    public MultiAddressWrite addInt16(String address, short data) {
        byte[] bytes = ShortUtil.toByteArray(data);
        this.addByte(address, bytes);
        return this;
    }

    public MultiAddressWrite addInt16(String address, int data) {
        byte[] bytes = ShortUtil.toByteArray(data);
        this.addByte(address, bytes);
        return this;
    }

    public MultiAddressWrite addUInt32(String address, long data) {
        byte[] bytes = IntegerUtil.toByteArray(data);
        this.addByte(address, bytes);
        return this;
    }

    public MultiAddressWrite addInt32(String address, int data) {
        byte[] bytes = IntegerUtil.toByteArray(data);
        this.addByte(address, bytes);
        return this;
    }

    public MultiAddressWrite addInt64(String address, long data) {
        byte[] bytes = LongUtil.toByteArray(data);
        this.addByte(address, bytes);
        return this;
    }

    public MultiAddressWrite addFloat32(String address, float data) {
        byte[] bytes = FloatUtil.toByteArray(data);
        this.addByte(address, bytes);
        return this;
    }

    public MultiAddressWrite addFloat64(String address, double data) {
        byte[] bytes = FloatUtil.toByteArray(data);
        this.addByte(address, bytes);
        return this;
    }

    public MultiAddressWrite addString(String address, String data) {
        this.addStringCustom(address, data, 1);
        return this;
    }

    public MultiAddressWrite addStringIn200Smart(String address, String data) {
        this.addStringCustom(address, data, 0);
        return this;
    }

    private void addStringCustom(String address, String data, int offset) {
        byte[] dataBytes = data.getBytes(Charset.forName("GB2312"));
        byte[] tmp = new byte[1 + dataBytes.length];
        tmp[0] = ByteUtil.toByte(dataBytes.length);
        System.arraycopy(dataBytes, 0, tmp, 1, dataBytes.length);
        RequestItem requestItem = AddressUtil.parseByte(address, tmp.length);
        requestItem.setByteAddress(requestItem.getByteAddress() + offset);
        this.requestItems.add(requestItem);
        this.dataItems.add(DataItem.createReqByByte(tmp));
    }

    public List<RequestItem> getRequestItems() {
        return this.requestItems;
    }

    public List<DataItem> getDataItems() {
        return this.dataItems;
    }

    public void setRequestItems(List<RequestItem> requestItems) {
        this.requestItems = requestItems;
    }

    public void setDataItems(List<DataItem> dataItems) {
        this.dataItems = dataItems;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiAddressWrite)) {
            return false;
        }
        MultiAddressWrite other = (MultiAddressWrite)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<RequestItem> this$requestItems = this.getRequestItems();
        List<RequestItem> other$requestItems = other.getRequestItems();
        if (this$requestItems == null ? other$requestItems != null : !((Object)this$requestItems).equals(other$requestItems)) {
            return false;
        }
        List<DataItem> this$dataItems = this.getDataItems();
        List<DataItem> other$dataItems = other.getDataItems();
        return !(this$dataItems == null ? other$dataItems != null : !((Object)this$dataItems).equals(other$dataItems));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MultiAddressWrite;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<RequestItem> $requestItems = this.getRequestItems();
        result = result * 59 + ($requestItems == null ? 43 : ((Object)$requestItems).hashCode());
        List<DataItem> $dataItems = this.getDataItems();
        result = result * 59 + ($dataItems == null ? 43 : ((Object)$dataItems).hashCode());
        return result;
    }

    public String toString() {
        return "MultiAddressWrite(requestItems=" + this.getRequestItems() + ", dataItems=" + this.getDataItems() + ")";
    }
}

