/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.service;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.exceptions.S7CommException;
import com.github.xingshuangs.iot.net.client.TcpClientBasic;
import com.github.xingshuangs.iot.protocol.s7.algorithm.S7ComGroup;
import com.github.xingshuangs.iot.protocol.s7.algorithm.S7ComItem;
import com.github.xingshuangs.iot.protocol.s7.algorithm.S7SequentialGroupAlg;
import com.github.xingshuangs.iot.protocol.s7.constant.ErrorCode;
import com.github.xingshuangs.iot.protocol.s7.enums.EDataVariableType;
import com.github.xingshuangs.iot.protocol.s7.enums.EDestinationFileSystem;
import com.github.xingshuangs.iot.protocol.s7.enums.EErrorClass;
import com.github.xingshuangs.iot.protocol.s7.enums.EFileBlockType;
import com.github.xingshuangs.iot.protocol.s7.enums.EParamVariableType;
import com.github.xingshuangs.iot.protocol.s7.enums.EPduType;
import com.github.xingshuangs.iot.protocol.s7.enums.EPlcType;
import com.github.xingshuangs.iot.protocol.s7.enums.EReturnCode;
import com.github.xingshuangs.iot.protocol.s7.model.AckHeader;
import com.github.xingshuangs.iot.protocol.s7.model.DataItem;
import com.github.xingshuangs.iot.protocol.s7.model.Mc7File;
import com.github.xingshuangs.iot.protocol.s7.model.NckRequestBuilder;
import com.github.xingshuangs.iot.protocol.s7.model.ReadWriteDatum;
import com.github.xingshuangs.iot.protocol.s7.model.ReadWriteParameter;
import com.github.xingshuangs.iot.protocol.s7.model.RequestItem;
import com.github.xingshuangs.iot.protocol.s7.model.RequestNckItem;
import com.github.xingshuangs.iot.protocol.s7.model.ReturnItem;
import com.github.xingshuangs.iot.protocol.s7.model.S7Data;
import com.github.xingshuangs.iot.protocol.s7.model.SetupComParameter;
import com.github.xingshuangs.iot.protocol.s7.model.StartUploadAckParameter;
import com.github.xingshuangs.iot.protocol.s7.model.TPKT;
import com.github.xingshuangs.iot.protocol.s7.model.UpDownloadDatum;
import com.github.xingshuangs.iot.protocol.s7.model.UploadAckParameter;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PLCNetwork
extends TcpClientBasic {
    private static final Logger log = LoggerFactory.getLogger(PLCNetwork.class);
    private final ReentrantLock locker = new ReentrantLock();
    protected EPlcType plcType = EPlcType.S1200;
    protected int rack = 0;
    protected int slot = 1;
    protected int pduLength;
    private boolean persistence = true;
    private BiConsumer<String, byte[]> comCallback;

    public PLCNetwork() {
    }

    public PLCNetwork(String host, int port) {
        super(host, port);
        this.tag = "S7";
    }

    @Override
    public void connect() {
        try {
            super.connect();
        }
        finally {
            if (!this.persistence) {
                this.close();
            }
        }
    }

    @Override
    protected void doAfterConnected() {
        this.connectionRequest();
        this.pduLength = this.connectDtData();
        log.debug("PLC[{}] handshake success, rack[{}]\uff0cslot[{}]\uff0cPDULength[{}]", new Object[]{this.plcType, this.rack, this.slot, this.pduLength});
    }

    private void connectionRequest() {
        int local = 256;
        int remote = 768;
        switch (this.plcType) {
            case S200: {
                local = 19799;
                remote = 19799;
                break;
            }
            case S200_SMART: {
                local = 4096;
                remote = 768;
                break;
            }
            case S300: 
            case S400: 
            case S1200: 
            case S1500: {
                remote += 32 * this.rack + this.slot;
                break;
            }
            case SINUMERIK_828D: {
                local = 1024;
                remote = 3332;
            }
        }
        S7Data req = S7Data.createConnectRequest(local, remote);
        S7Data ack = this.readFromServer(req);
        if (ack.getCotp().getPduType() != EPduType.CONNECT_CONFIRM) {
            throw new S7CommException("The connection request was denied");
        }
    }

    private int connectDtData() {
        S7Data req = S7Data.createConnectDtData(this.pduLength);
        S7Data ack = this.readFromServer(req);
        if (ack.getCotp().getPduType() != EPduType.DT_DATA) {
            throw new S7CommException("Connection Setup response error");
        }
        if (ack.getHeader() == null || ack.getHeader().byteArrayLength() != 12) {
            throw new S7CommException("Connection Setup response error, missing response header or insufficient response header length [12]");
        }
        int length = ((SetupComParameter)ack.getParameter()).getPduLength();
        if (length <= 0) {
            throw new S7CommException("The maximum length of a PDU is less than 0");
        }
        return length;
    }

    private S7Data readFromServer(S7Data req) {
        byte[] sendData = req.toByteArray();
        byte[] total = this.readFromServer(sendData);
        S7Data ack = S7Data.fromBytes(total);
        this.checkPostedCom(req, ack);
        return ack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFromServer(byte[] sendData) {
        byte[] total;
        int len;
        if (this.comCallback != null) {
            this.comCallback.accept("REQ", sendData);
        }
        if (this.pduLength > 0 && sendData.length - 7 > this.pduLength) {
            throw new S7CommException(String.format("The number of bytes sent for the request is too long [%d], which is larger than the maximum PDU length [%d].", sendData.length, this.pduLength));
        }
        try {
            this.locker.lock();
            this.write(sendData);
            byte[] data = new byte[4];
            len = this.read(data);
            if (len < 4) {
                throw new S7CommException("The TPKT is invalid and the length is inconsistent");
            }
            TPKT tpkt = TPKT.fromBytes(data);
            total = new byte[tpkt.getLength()];
            System.arraycopy(data, 0, total, 0, data.length);
            len = this.read(total, 4, tpkt.getLength() - 4);
        }
        finally {
            this.locker.unlock();
        }
        if (len < total.length - 4) {
            throw new S7CommException("The length of the data after TPKT is inconsistent");
        }
        if (this.comCallback != null) {
            this.comCallback.accept("ACK", total);
        }
        return total;
    }

    public S7Data readFromServerByPersistence(S7Data req) {
        try {
            S7Data s7Data = this.readFromServer(req);
            return s7Data;
        }
        finally {
            if (!this.persistence) {
                this.close();
            }
        }
    }

    public byte[] readFromServerByPersistence(byte[] req) {
        try {
            byte[] byArray = this.readFromServer(req);
            return byArray;
        }
        finally {
            if (!this.persistence) {
                this.close();
            }
        }
    }

    private void checkPostedCom(S7Data req, S7Data ack) {
        if (ack.getHeader() == null) {
            return;
        }
        AckHeader ackHeader = (AckHeader)ack.getHeader();
        if (ackHeader.getErrorClass() == null) {
            throw new S7CommException(String.format("Response exception, unknown exception\uff1a%s", ErrorCode.getMessage(ackHeader.getErrorCode())));
        }
        if (ackHeader.getErrorClass() != EErrorClass.NO_ERROR) {
            throw new S7CommException(String.format("Response exception, error type: %s, error cause\uff1a%s", ackHeader.getErrorClass().getDescription(), ErrorCode.getMessage(ackHeader.getErrorCode())));
        }
        if (ackHeader.getPduReference() != req.getHeader().getPduReference()) {
            throw new S7CommException("The PDU references are inconsistent, causing incorrect data");
        }
        if (ack.getDatum() == null) {
            return;
        }
        if (!(ack.getDatum() instanceof ReadWriteDatum)) {
            return;
        }
        ReadWriteDatum datum = (ReadWriteDatum)ack.getDatum();
        List<ReturnItem> returnItems = datum.getReturnItems();
        ReadWriteParameter parameter = (ReadWriteParameter)req.getParameter();
        if (returnItems.size() != parameter.getItemCount()) {
            throw new S7CommException("The returned data quantity is different from the requested data quantity");
        }
        for (int i = 0; i < returnItems.size(); ++i) {
            if (returnItems.get(i).getReturnCode() == EReturnCode.SUCCESS) continue;
            throw new S7CommException(String.format("Return [%d] result exception, address[%s], cause: %s", i + 1, parameter.getRequestItems().get(i).address(), returnItems.get(i).getReturnCode().getDescription()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataItem> readS7Data(List<RequestItem> requestItems) {
        if (requestItems == null || requestItems.isEmpty()) {
            throw new S7CommException("The request item is missing and the data cannot be retrieved");
        }
        List<Integer> rawNumbers = requestItems.stream().map(RequestItem::getCount).collect(Collectors.toList());
        List<DataItem> resultList = requestItems.stream().map(x -> DataItem.createReq(new byte[x.getByteCount()], x.getVariableType() == EParamVariableType.BIT ? EDataVariableType.BIT : EDataVariableType.BYTE_WORD_DWORD)).collect(Collectors.toList());
        List<S7ComGroup> s7ComGroups = S7SequentialGroupAlg.readRecombination(rawNumbers, this.pduLength - 14, 5, 12);
        try {
            s7ComGroups.forEach(x -> {
                List<S7ComItem> comItemList = x.getItems();
                List<RequestItem> newRequestItems = comItemList.stream().map(i -> {
                    RequestItem item = ((RequestItem)requestItems.get(i.getIndex())).copy();
                    item.setCount(i.getRipeSize());
                    item.setByteAddress(item.getByteAddress() + i.getSplitOffset());
                    return item;
                }).collect(Collectors.toList());
                S7Data req = S7Data.createReadRequest(newRequestItems);
                S7Data ack = this.readFromServer(req);
                ReadWriteDatum datum = (ReadWriteDatum)ack.getDatum();
                List dataItems = datum.getReturnItems().stream().map(DataItem.class::cast).collect(Collectors.toList());
                for (int i2 = 0; i2 < comItemList.size(); ++i2) {
                    S7ComItem comItem = comItemList.get(i2);
                    byte[] src = ((DataItem)dataItems.get(i2)).getData();
                    byte[] des = ((DataItem)resultList.get(comItem.getIndex())).getData();
                    System.arraycopy(src, 0, des, comItem.getSplitOffset(), src.length);
                }
            });
            List<DataItem> list = resultList;
            return list;
        }
        finally {
            if (!this.persistence) {
                this.close();
            }
        }
    }

    public DataItem readS7Data(RequestItem requestItem) {
        return this.readS7Data(Collections.singletonList(requestItem)).get(0);
    }

    public void writeS7Data(RequestItem requestItem, DataItem dataItem) {
        this.writeS7Data(Collections.singletonList(requestItem), Collections.singletonList(dataItem));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeS7Data(List<RequestItem> requestItems, List<DataItem> dataItems) {
        if (requestItems.size() != dataItems.size()) {
            throw new S7CommException("During the write operation, the number of requestItems and dataItems is inconsistent. Procedure");
        }
        List<Integer> rawNumbers = requestItems.stream().map(RequestItem::getCount).collect(Collectors.toList());
        List<S7ComGroup> s7ComGroups = S7SequentialGroupAlg.writeRecombination(rawNumbers, this.pduLength - 12, 17);
        try {
            s7ComGroups.forEach(x -> {
                List<S7ComItem> comItemList = x.getItems();
                List<RequestItem> newRequestItems = comItemList.stream().map(i -> {
                    RequestItem item = ((RequestItem)requestItems.get(i.getIndex())).copy();
                    item.setCount(i.getRipeSize());
                    item.setByteAddress(item.getByteAddress() + i.getSplitOffset());
                    return item;
                }).collect(Collectors.toList());
                List<DataItem> newDataItems = comItemList.stream().map(i -> {
                    DataItem item = ((DataItem)dataItems.get(i.getIndex())).copy();
                    item.setCount(i.getRipeSize());
                    item.setData(ByteReadBuff.newInstance(item.getData()).getBytes(i.getSplitOffset(), i.getRipeSize()));
                    return item;
                }).collect(Collectors.toList());
                S7Data req = S7Data.createWriteRequest(newRequestItems, newDataItems);
                this.readFromServer(req);
            });
        }
        finally {
            if (!this.persistence) {
                this.close();
            }
        }
    }

    public DataItem readS7NckData(RequestNckItem requestItem) {
        return this.readS7NckData(Collections.singletonList(requestItem)).get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataItem> readS7NckData(List<RequestNckItem> requestItems) {
        try {
            S7Data s7Data = NckRequestBuilder.creatNckRequest(requestItems);
            S7Data ack = this.readFromServer(s7Data);
            ReadWriteDatum datum = (ReadWriteDatum)ack.getDatum();
            List<DataItem> list = datum.getReturnItems().stream().map(DataItem.class::cast).collect(Collectors.toList());
            return list;
        }
        finally {
            if (!this.persistence) {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadFile(Mc7File mc7) {
        try {
            EDestinationFileSystem destinationFileSystem = EDestinationFileSystem.P;
            S7Data reqStartDownload = S7Data.createStartDownload(mc7.getBlockType(), mc7.getBlockNumber(), destinationFileSystem, mc7.getLoadMemoryLength(), mc7.getMC7CodeLength());
            this.readFromServer(reqStartDownload);
            ByteReadBuff buff = new ByteReadBuff(mc7.getData());
            while (buff.getRemainSize() > 0) {
                boolean moreDataFollowing = buff.getRemainSize() > this.pduLength - 32;
                byte[] tmpData = buff.getBytes(Math.min(buff.getRemainSize(), this.pduLength - 32));
                S7Data reqDownload = S7Data.createDownload(mc7.getBlockType(), mc7.getBlockNumber(), destinationFileSystem, moreDataFollowing, tmpData);
                this.readFromServer(reqDownload);
            }
            S7Data reqEndDownload = S7Data.createEndDownload(mc7.getBlockType(), mc7.getBlockNumber(), destinationFileSystem);
            this.readFromServer(reqEndDownload);
        }
        finally {
            if (!this.persistence) {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] uploadFile(EFileBlockType blockType, int blockNumber) {
        try {
            S7Data reqStartDownload = S7Data.createStartUpload(blockType, blockNumber, EDestinationFileSystem.A);
            S7Data ackStartDownload = this.readFromServer(reqStartDownload);
            StartUploadAckParameter startUploadAckParameter = (StartUploadAckParameter)ackStartDownload.getParameter();
            ByteWriteBuff buff = new ByteWriteBuff(startUploadAckParameter.getBlockLength());
            UploadAckParameter uploadAckParameter = new UploadAckParameter();
            uploadAckParameter.setMoreDataFollowing(true);
            while (uploadAckParameter.isMoreDataFollowing()) {
                S7Data reqUpload = S7Data.createUpload(startUploadAckParameter.getId());
                S7Data ackUpload = this.readFromServer(reqUpload);
                uploadAckParameter = (UploadAckParameter)ackUpload.getParameter();
                if (uploadAckParameter.isErrorStatus()) {
                    throw new S7CommException("Upload error occurred");
                }
                UpDownloadDatum datum = (UpDownloadDatum)ackUpload.getDatum();
                buff.putBytes(datum.getData());
            }
            S7Data reqEndUpload = S7Data.createEndUpload(startUploadAckParameter.getId());
            this.readFromServer(reqEndUpload);
            byte[] byArray = buff.getData();
            return byArray;
        }
        finally {
            if (!this.persistence) {
                this.close();
            }
        }
    }

    public ReentrantLock getLocker() {
        return this.locker;
    }

    public EPlcType getPlcType() {
        return this.plcType;
    }

    public int getRack() {
        return this.rack;
    }

    public int getSlot() {
        return this.slot;
    }

    public int getPduLength() {
        return this.pduLength;
    }

    public boolean isPersistence() {
        return this.persistence;
    }

    public BiConsumer<String, byte[]> getComCallback() {
        return this.comCallback;
    }

    public void setPlcType(EPlcType plcType) {
        this.plcType = plcType;
    }

    public void setRack(int rack) {
        this.rack = rack;
    }

    public void setSlot(int slot) {
        this.slot = slot;
    }

    public void setPduLength(int pduLength) {
        this.pduLength = pduLength;
    }

    public void setPersistence(boolean persistence) {
        this.persistence = persistence;
    }

    public void setComCallback(BiConsumer<String, byte[]> comCallback) {
        this.comCallback = comCallback;
    }

    public String toString() {
        return "PLCNetwork(locker=" + this.getLocker() + ", plcType=" + (Object)((Object)this.getPlcType()) + ", rack=" + this.getRack() + ", slot=" + this.getSlot() + ", pduLength=" + this.getPduLength() + ", persistence=" + this.isPersistence() + ", comCallback=" + this.getComCallback() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PLCNetwork)) {
            return false;
        }
        PLCNetwork other = (PLCNetwork)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getRack() != other.getRack()) {
            return false;
        }
        if (this.getSlot() != other.getSlot()) {
            return false;
        }
        if (this.getPduLength() != other.getPduLength()) {
            return false;
        }
        if (this.isPersistence() != other.isPersistence()) {
            return false;
        }
        ReentrantLock this$locker = this.getLocker();
        ReentrantLock other$locker = other.getLocker();
        if (this$locker == null ? other$locker != null : !this$locker.equals(other$locker)) {
            return false;
        }
        EPlcType this$plcType = this.getPlcType();
        EPlcType other$plcType = other.getPlcType();
        if (this$plcType == null ? other$plcType != null : !((Object)((Object)this$plcType)).equals((Object)other$plcType)) {
            return false;
        }
        BiConsumer<String, byte[]> this$comCallback = this.getComCallback();
        BiConsumer<String, byte[]> other$comCallback = other.getComCallback();
        return !(this$comCallback == null ? other$comCallback != null : !this$comCallback.equals(other$comCallback));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PLCNetwork;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getRack();
        result = result * 59 + this.getSlot();
        result = result * 59 + this.getPduLength();
        result = result * 59 + (this.isPersistence() ? 79 : 97);
        ReentrantLock $locker = this.getLocker();
        result = result * 59 + ($locker == null ? 43 : $locker.hashCode());
        EPlcType $plcType = this.getPlcType();
        result = result * 59 + ($plcType == null ? 43 : ((Object)((Object)$plcType)).hashCode());
        BiConsumer<String, byte[]> $comCallback = this.getComCallback();
        result = result * 59 + ($comCallback == null ? 43 : $comCallback.hashCode());
        return result;
    }
}

